/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term;

import com.heirloomcomputing.term.Field;
import com.heirloomcomputing.term.FieldException;
import com.heirloomcomputing.term.Text;
import java.awt.Dimension;
import java.awt.Point;

public abstract class Form {
    private Text[] text;
    private Text[] textInScreenOrder;
    private Field[] fields;
    private Field[] fieldsInScreenOrder;
    private Point cursorLocation = new Point(0, 0);
    private Dimension displaySize = new Dimension(80, 24);
    private Text status;

    public Field[] getFields() {
        return this.fields;
    }

    public void setFields(Field[] fieldArray) {
        this.fields = fieldArray;
        this.fieldsInScreenOrder = null;
    }

    public int getNumberOfFields() {
        Field[] fieldArray = this.getFields();
        if (fieldArray == null) {
            return 0;
        }
        return fieldArray.length;
    }

    private Text[] sortByScreenOrder(Text[] textArray) {
        if (textArray == null) {
            return null;
        }
        int n = textArray.length;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = 0; j <= i; ++j) {
                Text text = textArray[j + 1];
                Point point = text.getLocation();
                Text text2 = textArray[j];
                Point point2 = text2.getLocation();
                if (point.y >= point2.y && (point.y != point2.y || point.x >= point2.x)) continue;
                textArray[j + 1] = text2;
                textArray[j] = text;
            }
        }
        return textArray;
    }

    public Field getField(int n) {
        if (n > 0) {
            if (this.fields == null) {
                return null;
            }
            try {
                return this.fields[n - 1];
            }
            catch (Exception exception) {
                return null;
            }
        }
        n = n == 0 ? 1 : -n;
        if (this.fieldsInScreenOrder == null) {
            if (this.fields == null) {
                return null;
            }
            int n2 = this.fields.length;
            if (n2 == 0) {
                return null;
            }
            this.fieldsInScreenOrder = new Field[n2];
            System.arraycopy(this.fields, 0, this.fieldsInScreenOrder, 0, n2);
            this.fieldsInScreenOrder = (Field[])this.sortByScreenOrder(this.fieldsInScreenOrder);
        }
        try {
            return this.fieldsInScreenOrder[n - 1];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Field getField(Point point) {
        int n = this.getFieldIndex(point);
        if (n == 0) {
            return null;
        }
        return this.getField(n);
    }

    public int getFieldIndex(Point point) {
        int n = -this.getNumberOfFields();
        for (int i = -1; i >= n; --i) {
            Field field = this.getField(i);
            Point point2 = field.getLocation();
            if (point2.y < point.y) continue;
            if (point2.y > point.y || point2.x > point.x) break;
            int n2 = field.getDisplayLength();
            if (point2.x + n2 <= point.x) continue;
            return i;
        }
        return 0;
    }

    public void clearFieldErrors() {
        int n = this.getNumberOfFields();
        for (int i = 1; i <= n; ++i) {
            Field field = this.getField(i);
            field.setError(false);
        }
    }

    public int getFirstFieldWithError() {
        int n = -this.getNumberOfFields();
        for (int i = -1; i >= n; --i) {
            Field field = this.getField(i);
            if (!field.isError()) continue;
            return i;
        }
        return 0;
    }

    public Text[] getText() {
        return this.text;
    }

    public void setText(Text[] textArray) {
        this.text = textArray;
        this.textInScreenOrder = null;
    }

    public int getNumberOfTextElements() {
        Text[] textArray = this.getText();
        if (textArray == null) {
            return 0;
        }
        return textArray.length;
    }

    public Text getText(int n) {
        if (n > 0) {
            if (this.text == null) {
                return null;
            }
            try {
                return this.text[n - 1];
            }
            catch (Exception exception) {
                return null;
            }
        }
        n = n == 0 ? 1 : -n;
        if (this.textInScreenOrder == null) {
            if (this.text == null) {
                return null;
            }
            int n2 = this.text.length;
            if (n2 == 0) {
                return null;
            }
            this.textInScreenOrder = new Field[n2];
            System.arraycopy(this.text, 0, this.textInScreenOrder, 0, n2);
            this.textInScreenOrder = this.sortByScreenOrder(this.textInScreenOrder);
        }
        try {
            return this.textInScreenOrder[n - 1];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Text getText(Point point) {
        int n = this.getNumberOfTextElements();
        for (int i = 1; i <= n; ++i) {
            Text text = this.getText(-i);
            Point point2 = text.getLocation();
            if (point2.y < point.y) continue;
            if (point2.y > point.y || point2.x > point.x) break;
            int n2 = text.getDisplayLength();
            if (point2.x + n2 <= point.x) continue;
            return text;
        }
        return null;
    }

    public Point getCursorLocation() {
        return this.cursorLocation;
    }

    public void setCursorLocation(Point point) {
        this.cursorLocation = point;
    }

    public Dimension getDisplaySize() {
        return this.displaySize;
    }

    public void setDisplaySize(Dimension dimension) {
        this.displaySize = dimension;
    }

    public void setStatus(Text text) {
        this.status = text;
    }

    public Text getStatus() {
        return this.status;
    }

    public abstract void showForm(boolean var1, boolean var2, Text[] var3, Text[] var4, Text var5);

    protected abstract int readField(int var1, Object[] var2) throws FieldException;

    protected abstract Object waitForTerminator(Object[] var1);

    protected int getStartingFieldForRead() {
        int n = this.getFirstFieldWithError();
        if (n < 0) {
            return n;
        }
        Field field = this.getField(this.getCursorLocation());
        if (field != null) {
            int n2 = -this.getNumberOfFields();
            for (int i = -1; i >= n2; --i) {
                Field field2 = this.getField(i);
                if (field2 != field) continue;
                return i;
            }
        }
        return -1;
    }

    public int getNumberOfEditableFields() {
        int n = 0;
        int n2 = this.getNumberOfFields();
        for (int i = 1; i <= n2; ++i) {
            Field field = this.getField(i);
            if (!field.isEditable() || field.getDisplayLength() <= 0) continue;
            ++n;
        }
        return n;
    }

    public Object readFields(Object[] objectArray) {
        if (this.getNumberOfEditableFields() == 0) {
            return this.waitForTerminator(objectArray);
        }
        int n = this.getStartingFieldForRead();
        Field field = this.getField(n);
        this.setCursorLocation(field.getLocation());
        while (true) {
            try {
                while (true) {
                    n = this.readField(n, objectArray);
                }
            }
            catch (FieldException fieldException) {
                if (!fieldException.getTerminatorPressed()) continue;
                return fieldException.getTerminator();
            }
            break;
        }
    }
}

