/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term;

import com.heirloomcomputing.term.AWTPanel;
import com.heirloomcomputing.term.GFXHandlerJFC;
import com.heirloomcomputing.term.KeyValue;
import com.heirloomcomputing.term.ScreenHandler;
import com.heirloomcomputing.term.ScreenProperty;
import com.heirloomcomputing.term.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class GFXHandler
implements ScreenHandler,
FocusListener,
KeyListener {
    public static boolean debugMode;
    public static final int DEFAULT_LINES = 25;
    public static final int DEFAULT_COLUMNS = 80;
    private static final String preferredFontName = "Monospaced";
    private static final int fgShift = 14;
    private static final int bgShift = 18;
    private static final int fgColorMask = 245760;
    private static final int bgColorMask = 0x3C0000;
    private static final int bgColorSetMask = 0x400000;
    private static final int fgColorSetMask = 0x800000;
    private static final int colorMask = 0xFFC000;
    private static final int mask = 1375730876;
    private int lines = 25;
    private int columns = 80;
    private boolean forcedTimeout = false;
    private boolean isJFC = false;
    private Container panelForWindow;
    private int cellWidth = -1;
    private int cellHeight = -1;
    private int cursorx = 0;
    private int cursory = 0;
    private int defaultFG = -1;
    private int defaultBG = -1;
    private int curIndexFG = -1;
    private int curIndexBG = -1;
    private int curAttr = 0;
    public Color curFG;
    public Color curBG;
    private int curFontSize = 12;
    private boolean reverseMode = false;
    private boolean underlineMode = false;
    private boolean highlightMode = false;
    private boolean reverseIt = false;
    private boolean leftlineMode = false;
    private boolean overlineMode = false;
    private boolean gridlineMode = false;
    private Vector<ActionListener> actionListeners = null;
    private char secureChar = (char)32;
    private boolean secureCharSet = false;
    private boolean dataModified = false;
    private Vector<GFXHandlerField>[] fieldsByLine = null;
    private boolean isDirty = false;
    private KeyValue terminator = null;
    private KeyValue exitKey = null;
    private int numInputFields = 0;
    private String allowChars = null;
    private boolean forceUppercase = false;
    private KeyValue[] terminatorsToListenFor = null;
    private boolean addNotifyCalled = false;
    public font curFont;
    public font boldFont;
    public font plainFont;
    private boolean listenForFocus = false;
    private Component focusComponent = null;
    private boolean focusLostTrigger = false;
    private GFXHandlerJFC termJFC;
    private final Object o = new Object();
    private Dimension pSize = new Dimension(0, 0);
    public static String defaultFontName;
    public static int defaultFontWidth;
    public static int defaultFontWidthMin;
    public static int defaultFontWidthMax;
    public static double defaultFontWidthMult;

    public static void debug(String string2) {
        System.out.println("GFXHandler: " + string2);
    }

    public GFXHandler() throws Throwable {
        this("Console", Color.black, Color.lightGray, 25, 80);
    }

    public GFXHandler(String string2) throws Throwable {
        this(string2, Color.black, Color.lightGray, 25, 80);
    }

    public GFXHandler(String string2, Color color2, Color color3) throws Throwable {
        this(string2, color2, color3, 25, 80);
    }

    public GFXHandler(String string2, Color color2, Color color3, int n, int n2) throws Throwable {
        String string3;
        if (debugMode) {
            GFXHandler.debug("Called GFXHandler(), lines=" + n);
        }
        this.lines = n;
        this.columns = n2;
        this.fieldsByLine = new Vector[n];
        String string4 = null;
        String string5 = null;
        try {
            string4 = Utilities.getParameter("user.region");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string4 == null) {
            string4 = "US";
        }
        try {
            string5 = Utilities.getParameter("user.language");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string5 == null) {
            string5 = "en";
        }
        if ((string3 = Utilities.getParameter("console_font_size_" + string5 + "_" + string4)) == null) {
            string3 = Utilities.getParameter("console_font_size_" + string5);
        }
        if (string3 == null) {
            string3 = Utilities.getParameter("console_font_size");
        }
        if (string3 == null) {
            this.curFontSize = 12;
        } else {
            try {
                this.curFontSize = Utilities.parseInt(string3);
            }
            catch (Exception exception) {
                this.curFontSize = 12;
            }
        }
        try {
            new JLabel();
            this.isJFC = true;
        }
        catch (Throwable throwable) {
            this.isJFC = false;
        }
        this.panelForWindow = this.createPanel();
        this.setFontSize(this.curFontSize);
        color2 = Color.black;
        color3 = Color.lightGray;
        int n3 = ScreenProperty.getClosestColorIndex(color2);
        int n4 = ScreenProperty.getClosestColorIndex(color3);
        this.curFG = ScreenProperty.getColorObject(n3);
        this.curBG = ScreenProperty.getColorObject(n4);
        this.setDefaultColors(n3, n4);
    }

    private Container createPanel() {
        if (this.isJFC) {
            if (this.termJFC == null) {
                this.termJFC = new GFXHandlerJFC();
            }
            return this.termJFC.createPanel(this);
        }
        return new AWTPanel(this);
    }

    public void addNotify() {
        this.addNotifyCalled = true;
        Container container = this.getPanelForWindow();
        Color color2 = container.getForeground();
        Color color3 = container.getBackground();
        int n = ScreenProperty.getClosestColorIndex(color2);
        int n2 = ScreenProperty.getClosestColorIndex(color3);
        this.curFG = ScreenProperty.getColorObject(n);
        this.curBG = ScreenProperty.getColorObject(n2);
        this.setDefaultColors(n, n2);
        this.forceRefresh();
        this.refresh();
    }

    private int getNumberOfInputFields() {
        return this.numInputFields;
    }

    private Window getWindowForComponent(Component component) {
        while (component != null) {
            if (component instanceof Window) {
                return (Window)component;
            }
            component = component.getParent();
        }
        return null;
    }

    private GFXHandlerField getFieldAt(int n, int n2) {
        int n3 = this.getCellWidth() * n2;
        Vector<GFXHandlerField> vector = this.fieldsByLine[n];
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            GFXHandlerField gFXHandlerField = vector.elementAt(i);
            Rectangle rectangle = gFXHandlerField.getBounds();
            if (n3 < rectangle.x) continue;
            if (n3 > rectangle.x + rectangle.width) break;
            return gFXHandlerField;
        }
        return null;
    }

    private String getFieldValue(Component component) {
        try {
            if (this.isJFC) {
                if (component instanceof JLabel) {
                    return null;
                }
                return ((JTextField)component).getText();
            }
            if (component instanceof Label) {
                return null;
            }
            return ((TextField)component).getText();
        }
        catch (Exception exception) {
            if (debugMode) {
                exception.printStackTrace(System.out);
            }
            return null;
        }
    }

    private String getFieldValueAt(int n, int n2) {
        GFXHandlerField gFXHandlerField;
        if (debugMode) {
            GFXHandler.debug("Called getFieldValueAt(" + n + ", " + n2 + ")");
        }
        if ((gFXHandlerField = this.getFieldAt(n, n2)) == null) {
            if (debugMode) {
                GFXHandler.debug("field is null!");
            }
            return null;
        }
        Component component = gFXHandlerField.getComponent();
        if (component == null) {
            return gFXHandlerField.getText();
        }
        return this.getFieldValue(component);
    }

    private boolean innerRefresh() {
        if (debugMode) {
            GFXHandler.debug("Called innerRefresh()");
        }
        if (!this.addNotifyCalled) {
            return false;
        }
        Container container = this.getPanelForWindow();
        if (container != null) {
            container.repaint();
        }
        this.isDirty = false;
        if (debugMode) {
            GFXHandler.debug("Done with innerRefresh()");
        }
        return true;
    }

    private void scroll() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = this.o;
        synchronized (object) {
            if (this.focusLostTrigger) {
                this.focusComponent = focusEvent.getComponent();
                this.focusLostTrigger = false;
                this.terminator = null;
                this.exitKey = null;
                this.notifyOfFocusChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void focusLost(FocusEvent focusEvent) {
        Object object = this.o;
        synchronized (object) {
            if (!this.listenForFocus) {
                return;
            }
            if (focusEvent != null && !focusEvent.isTemporary()) {
                this.focusComponent = null;
                this.focusLostTrigger = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFocusChange() {
        Object object = this.o;
        synchronized (object) {
            this.listenForFocus = true;
            try {
                this.o.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.listenForFocus = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyOfFocusChange() {
        Object object = this.o;
        synchronized (object) {
            try {
                this.o.notify();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Object object = this.o;
        synchronized (object) {
            KeyValue keyValue = new KeyValue(keyEvent);
            int n = keyValue.getKeyModifier();
            char c = keyValue.getKeyChar();
            if (n == 0 && GFXHandler.isPrintable(c)) {
                char c2;
                if (this.allowChars != null && this.allowChars.indexOf(c) < 0) {
                    keyEvent.consume();
                    return;
                }
                if (this.forceUppercase && c != (c2 = Character.toUpperCase(c))) {
                    Component component = keyEvent.getComponent();
                    if (component != null) {
                        component.dispatchEvent(new KeyEvent(component, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers() | 1, keyEvent.getKeyCode(), c2));
                    }
                    keyEvent.consume();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent keyEvent) {
        Object object = this.o;
        synchronized (object) {
            char c;
            KeyValue keyValue = new KeyValue(keyEvent);
            int n = keyValue.getKeyModifier();
            int n2 = keyValue.getKeyCode();
            char c2 = keyValue.getKeyChar();
            if (n == 0 && GFXHandler.isPrintable(c2)) {
                if (this.allowChars != null && this.allowChars.indexOf(c2) < 0) {
                    keyEvent.consume();
                    return;
                }
                if (this.forceUppercase && c2 != (c = Character.toUpperCase(c2))) {
                    Component component = keyEvent.getComponent();
                    if (component != null) {
                        component.dispatchEvent(new KeyEvent(component, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers() | 1, keyEvent.getKeyCode(), c));
                    }
                    keyEvent.consume();
                    return;
                }
            }
            if (this.terminatorsToListenFor != null) {
                if (debugMode) {
                    GFXHandler.debug("terminatorsToListenFor.length=" + this.terminatorsToListenFor.length);
                }
                for (c = '\u0000'; c < this.terminatorsToListenFor.length; ++c) {
                    if (debugMode) {
                        GFXHandler.debug("terminatorsToListenFor[" + c + "]=" + this.terminatorsToListenFor[c]);
                    }
                    if (debugMode && this.terminatorsToListenFor[c] == null) {
                        GFXHandler.debug("PROBLEM!");
                    }
                    if (!keyValue.equals(this.terminatorsToListenFor[c])) continue;
                    this.terminator = keyValue;
                    this.exitKey = null;
                    this.notifyOfFocusChange();
                    return;
                }
            }
            this.terminator = null;
            if (n == 1) {
                if (n2 == 9) {
                    this.exitKey = keyValue;
                    this.notifyOfFocusChange();
                    return;
                }
            } else if (n == 2) {
                if (n2 == 36) {
                    this.exitKey = keyValue;
                    this.notifyOfFocusChange();
                    return;
                }
                if (n2 == 35) {
                    this.exitKey = keyValue;
                    this.notifyOfFocusChange();
                    return;
                }
            } else if (n == 0 && n2 == 9) {
                this.exitKey = keyValue;
                this.notifyOfFocusChange();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyTyped(KeyEvent keyEvent) {
        Object object = this.o;
        synchronized (object) {
            KeyValue keyValue = new KeyValue(keyEvent);
            int n = keyValue.getKeyModifier();
            char c = keyValue.getKeyChar();
            if (n == 0 && GFXHandler.isPrintable(c)) {
                char c2;
                if (this.allowChars != null && this.allowChars.indexOf(c) < 0) {
                    keyEvent.consume();
                    return;
                }
                if (this.forceUppercase && c != (c2 = Character.toUpperCase(c))) {
                    Component component = keyEvent.getComponent();
                    if (component != null) {
                        component.dispatchEvent(new KeyEvent(component, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers() | 1, keyEvent.getKeyCode(), c2));
                    }
                    keyEvent.consume();
                    return;
                }
            }
        }
    }

    public static final boolean isPrintable(char c) {
        return c >= ' ' && c != '\u007f' && c != '\uffff';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean print(String string2) {
        if (debugMode) {
            GFXHandler.debug("Called print(" + string2 + ")");
        }
        if (string2 == null) {
            return false;
        }
        boolean bl = (this.curAttr & 0x20000000) == 0x20000000;
        int n = string2.length();
        string2 = string2.trim();
        int n2 = this.getCellWidth();
        int n3 = this.getCellHeight();
        int n4 = n2 * this.cursorx;
        int n5 = n3 * this.cursory;
        int n6 = n2 * n + 5;
        int n7 = n3;
        if (bl || string2.length() > 0) {
            block24: {
                try {
                    Object object;
                    Serializable serializable;
                    GFXHandlerField gFXHandlerField;
                    int n8;
                    String string3 = (bl ? "Field " : "Label ") + "(" + this.cursorx + ", " + this.cursory + ")";
                    Vector<GFXHandlerField> vector = this.fieldsByLine[this.cursory];
                    if (vector == null) {
                        Component component;
                        GFXHandlerField gFXHandlerField2 = new GFXHandlerField(string3, bl, string2, n, n4, n5, n6, n7, this.isJFC, this.curFG, this.curBG);
                        Container container = this.getPanelForWindow();
                        if (container != null && (component = gFXHandlerField2.getComponent()) != null) {
                            if (bl) {
                                component.addFocusListener(this);
                            }
                            container.add(component);
                        }
                        vector = new Vector();
                        vector.addElement(gFXHandlerField2);
                        this.fieldsByLine[this.cursory] = vector;
                        break block24;
                    }
                    int n9 = vector.size();
                    for (n8 = 0; n8 < n9; ++n8) {
                        Component component;
                        gFXHandlerField = vector.elementAt(n8);
                        serializable = gFXHandlerField.getBounds();
                        if (n4 == ((Rectangle)serializable).x) {
                            object = gFXHandlerField.getComponent();
                            vector.removeElementAt(n8);
                            GFXHandlerField gFXHandlerField3 = new GFXHandlerField(string3, bl, string2, n, n4, n5, n6, n7, this.isJFC, this.curFG, this.curBG);
                            Container container = this.getPanelForWindow();
                            if (container != null) {
                                Object object2 = container.getTreeLock();
                                synchronized (object2) {
                                    if (((Component)object).getParent() == container) {
                                        if (gFXHandlerField.isField()) {
                                            ((Component)object).removeFocusListener(this);
                                        }
                                        container.remove((Component)object);
                                        object = gFXHandlerField3.getComponent();
                                        if (bl) {
                                            ((Component)object).addFocusListener(this);
                                        }
                                        container.add((Component)object);
                                    }
                                }
                            }
                            vector.insertElementAt(gFXHandlerField3, n8);
                            break;
                        }
                        if (n4 <= ((Rectangle)serializable).x) continue;
                        object = new GFXHandlerField(string3, bl, string2, n, n4, n5, n6, n7, this.isJFC, this.curFG, this.curBG);
                        Container container = this.getPanelForWindow();
                        if (container != null && (component = ((GFXHandlerField)object).getComponent()) != null) {
                            if (bl) {
                                component.addFocusListener(this);
                            }
                            container.add(component);
                        }
                        vector.insertElementAt((GFXHandlerField)object, n8);
                        break;
                    }
                    if (n8 == n9) {
                        gFXHandlerField = new GFXHandlerField(string3, bl, string2, n, n4, n5, n6, n7, this.isJFC, this.curFG, this.curBG);
                        serializable = this.getPanelForWindow();
                        if (serializable != null && (object = gFXHandlerField.getComponent()) != null) {
                            if (bl) {
                                ((Component)object).addFocusListener(this);
                            }
                            ((Container)serializable).add((Component)object);
                        }
                        vector.addElement(gFXHandlerField);
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            this.isDirty = true;
            if (bl) {
                ++this.numInputFields;
            }
        }
        this.cursorx += n;
        if (this.cursorx >= this.columns) {
            this.cursorx = this.columns - 1;
        }
        return true;
    }

    @Override
    public boolean println(String string2) {
        this.print(string2);
        if (this.cursory + 1 >= this.lines) {
            this.scroll();
            this.move(this.lines - 1, 0);
            return true;
        }
        this.move(this.cursory + 1, 0);
        return true;
    }

    @Override
    public String getString(String string2, boolean bl, boolean bl2, KeyValue[] keyValueArray, int n, boolean bl3, char c, String string3, boolean bl4, String string4) {
        String string5;
        String string6;
        block38: {
            Window window;
            GFXHandlerField gFXHandlerField;
            if (debugMode) {
                GFXHandler.debug("Called getString(...), curString=" + string2 + ", addNotifyCalled=" + this.addNotifyCalled + ", cursorx=" + this.cursorx + ", cursory=" + this.cursory);
            }
            if (this.isDirty) {
                this.refresh();
            }
            if ((gFXHandlerField = this.getFieldAt(this.cursory, this.cursorx)) == null) {
                return null;
            }
            Component component = gFXHandlerField.getComponent();
            if (component == null) {
                return null;
            }
            if (debugMode) {
                GFXHandler.debug("getting window for component");
            }
            if ((window = this.getWindowForComponent(component)) == null) {
                return null;
            }
            Component component2 = null;
            this.forcedTimeout = false;
            int n2 = 0;
            if (string2 != null) {
                n2 = string2.length();
            }
            string6 = null;
            string5 = null;
            this.allowChars = string3;
            this.forceUppercase = bl4;
            this.terminatorsToListenFor = keyValueArray;
            this.dataModified = false;
            this.terminator = null;
            this.exitKey = null;
            while ((component2 = window.getFocusOwner()) != null && component2 != component) {
                component.requestFocus();
                component2.transferFocus();
                try {
                    Thread.sleep(150L);
                }
                catch (Exception exception) {}
            }
            if (this.isJFC) {
                try {
                    if (bl2) {
                        ((JPasswordField)component).setEchoChar(this.getSecureChar());
                    } else {
                        ((JPasswordField)component).setEchoChar('\u0000');
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (n >= 0) {
                        ((JTextComponent)component).setCaretPosition(n);
                        component.repaint();
                    }
                }
                catch (Exception exception) {}
            } else {
                try {
                    if (bl2) {
                        ((TextField)component).setEchoChar(this.getSecureChar());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string5 = this.getFieldValue(component);
            component.addKeyListener(this);
            if (debugMode) {
                GFXHandler.debug("waiting for focus change");
            }
            this.waitForFocusChange();
            if (debugMode) {
                GFXHandler.debug("Done...");
            }
            component.removeKeyListener(this);
            string6 = this.getFieldValue(component);
            if (debugMode) {
                GFXHandler.debug("value=" + string6 + ", terminator=" + this.terminator + ", exitKey=" + this.exitKey);
            }
            if (string6 != null && string6.length() > n2) {
                string6 = string6.substring(0, n2);
            }
            try {
                if (this.terminator == null && this.exitKey == null) {
                    if (this.focusComponent != null && this.focusComponent != component) {
                        Point point = this.focusComponent.getLocation();
                        this.focusComponent = null;
                        int n3 = this.getCellWidth();
                        int n4 = this.getCellHeight();
                        if (n3 > 0 && n4 > 0) {
                            int n5 = point.x / n3;
                            int n6 = point.y / n4;
                            if (debugMode) {
                                GFXHandler.debug("Calling fireActionEvent...");
                            }
                            this.exitKey = null;
                            this.fireActionEvent(new ActionEvent(this, 0, "MOUSE_RELEASED " + n5 + ", " + n6));
                            if (string6 != null && !string6.equals(string5)) {
                                this.dataModified = true;
                            }
                            return string6;
                        }
                    } else {
                        if (debugMode) {
                            GFXHandler.debug("Focus component is null or same as c, focusComponent=" + this.focusComponent);
                        }
                        this.focusComponent = null;
                    }
                }
            }
            catch (Exception exception) {
                if (!debugMode) break block38;
                exception.printStackTrace(System.out);
            }
        }
        if (debugMode) {
            GFXHandler.debug("returning value='" + string6 + "', terminator=" + this.terminator + ", exitKey=" + this.exitKey);
        }
        if (string6 != null && !string6.equals(string5)) {
            this.dataModified = true;
        }
        return string6;
    }

    @Override
    public String getString() {
        this.forcedTimeout = false;
        return null;
    }

    @Override
    public void waitForTerminatorKey(KeyValue[] keyValueArray) {
        this.forcedTimeout = false;
        Window window = this.getWindowForComponent(this.getPanelForWindow());
        if (window == null) {
            return;
        }
        if (debugMode) {
            GFXHandler.debug("Calling addKeyListener...");
        }
        this.terminatorsToListenFor = keyValueArray;
        window.addKeyListener(this);
        if (debugMode) {
            GFXHandler.debug("waiting for focus change");
        }
        this.waitForFocusChange();
        if (debugMode) {
            GFXHandler.debug("Done...");
        }
        window.removeKeyListener(this);
    }

    @Override
    public KeyValue getTerminator() {
        return this.terminator;
    }

    @Override
    public KeyValue getExitKey() {
        return this.exitKey;
    }

    @Override
    public void clearScreen() {
        for (int i = 0; i < this.lines; ++i) {
            Vector<GFXHandlerField> vector = this.fieldsByLine[i];
            if (vector == null) continue;
            int n = vector.size();
            for (int j = 0; j < n; ++j) {
                Component component;
                GFXHandlerField gFXHandlerField = vector.elementAt(j);
                if (!gFXHandlerField.isField() || (component = gFXHandlerField.getComponent()) == null) continue;
                component.removeFocusListener(this);
            }
            vector.removeAllElements();
            this.isDirty = true;
        }
        Container container = this.getPanelForWindow();
        if (container != null) {
            container.removeAll();
        }
        this.numInputFields = 0;
        this.move(0, 0);
    }

    @Override
    public void clrtoeol() {
    }

    @Override
    public void clrtobot() {
    }

    @Override
    public void showCursor() {
    }

    @Override
    public void hideCursor() {
    }

    @Override
    public boolean refresh() {
        if (this.isDirty) {
            return this.innerRefresh();
        }
        return true;
    }

    @Override
    public boolean setDefaultColors(int n, int n2) {
        if (n >= 0) {
            this.defaultFG = n;
        }
        if (n2 >= 0) {
            this.defaultBG = n2;
        }
        this.forceRefresh();
        return true;
    }

    @Override
    public boolean setDefaultColors(Color color2, Color color3) {
        int n = -1;
        if (color2 != null) {
            n = ScreenProperty.getClosestColorIndex(color2);
        }
        int n2 = -1;
        if (color3 != null) {
            n2 = ScreenProperty.getClosestColorIndex(color3);
        }
        return this.setDefaultColors(n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setScreenResolution(int n, int n2) {
        if (debugMode) {
            GFXHandler.debug("Called setScreenResolution(" + n + ", " + n2 + ")");
        }
        this.hideCursor();
        this.lines = n;
        this.columns = n2;
        int n3 = this.getCellHeight() * n;
        int n4 = this.getCellWidth() * n2;
        Serializable serializable = this.pSize;
        synchronized (serializable) {
            this.pSize.width = n4;
            this.pSize.height = n3;
        }
        serializable = this.getPanelForWindow();
        ((Component)serializable).setSize(n4, n3);
        int n5 = this.cursorx;
        int n6 = this.cursory;
        this.clearScreen();
        this.move(n6, n5);
        return true;
    }

    @Override
    public int getCellWidth() {
        if (this.cellWidth < 0) {
            this.cellWidth = this.plainFont.getWidth();
        }
        return this.cellWidth;
    }

    @Override
    public void setCellWidth(int n) {
        this.cellWidth = n;
    }

    @Override
    public int getCellHeight() {
        if (this.cellHeight < 0) {
            this.cellHeight = this.plainFont.getHeight() + 1;
        }
        return this.cellHeight;
    }

    @Override
    public void setCellHeight(int n) {
        this.cellHeight = n;
    }

    @Override
    public Font getFont() {
        return this.curFont.getFont();
    }

    @Override
    public void setFont(Font font2) {
        if (font2 == null) {
            return;
        }
        defaultFontName = font2.getName();
        this.setFontSize(font2.getSize());
    }

    @Override
    public boolean setFontSize(int n) {
        Container container;
        if (debugMode) {
            GFXHandler.debug("Called setFontSize(" + n + ")");
        }
        if (this.boldFont != null && this.boldFont.getSize() == n) {
            return true;
        }
        this.curFontSize = n;
        this.setCellWidth(-1);
        this.setCellHeight(-1);
        Container container2 = this.getPanelForWindow();
        this.plainFont = new font(n, false, container2);
        this.boldFont = new font(n, true, container2);
        this.curFont = this.plainFont;
        this.setScreenResolution(this.lines, this.columns);
        for (container = container2; container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        if (container != null) {
            Frame frame = (Frame)container;
            frame.setVisible(true);
            frame.pack();
        }
        return true;
    }

    @Override
    public boolean move(int n, int n2) {
        if (n >= this.lines || n2 >= this.columns || n < 0 || n2 < 0) {
            return false;
        }
        this.cursorx = n2;
        this.cursory = n;
        return true;
    }

    @Override
    public int getLines() {
        return this.lines;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public int getCursorX() {
        return this.cursorx;
    }

    @Override
    public int getCursorY() {
        return this.cursory;
    }

    @Override
    public void beep() {
        Utilities.beep();
    }

    @Override
    public void setScrollable(boolean bl) {
    }

    @Override
    public Container getPanelForWindow() {
        return this.panelForWindow;
    }

    @Override
    public KeyValue getChar() {
        return null;
    }

    @Override
    public void forceRefresh() {
        this.isDirty = true;
    }

    @Override
    public void setGetStringTimeout(long l) {
    }

    @Override
    public void forceGetStringTimeout() {
        if (!this.forcedTimeout) {
            this.forcedTimeout = true;
        }
    }

    @Override
    public boolean isGetStringTimeout() {
        return this.forcedTimeout;
    }

    @Override
    public boolean isDataModified() {
        return this.dataModified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionEvent(ActionEvent actionEvent) {
        if (debugMode) {
            GFXHandler.debug("Called fireActionEvent(" + actionEvent + ")");
        }
        if (this.actionListeners != null) {
            if (debugMode) {
                GFXHandler.debug("synchronized on actionListeners");
            }
            Vector<ActionListener> vector = this.actionListeners;
            synchronized (vector) {
                for (int i = 0; i < this.actionListeners.size(); ++i) {
                    ActionListener actionListener2 = this.actionListeners.elementAt(i);
                    if (debugMode) {
                        GFXHandler.debug("l=" + actionListener2);
                    }
                    actionListener2.actionPerformed(actionEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addActionListener(ActionListener actionListener2) {
        if (actionListener2 == null) {
            return;
        }
        if (this.actionListeners == null) {
            this.actionListeners = new Vector();
        }
        Vector<ActionListener> vector = this.actionListeners;
        synchronized (vector) {
            if (!this.actionListeners.contains(actionListener2)) {
                this.actionListeners.addElement(actionListener2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActionListener(ActionListener actionListener2) {
        if (actionListener2 == null || this.actionListeners == null) {
            return;
        }
        Vector<ActionListener> vector = this.actionListeners;
        synchronized (vector) {
            if (!this.actionListeners.contains(actionListener2)) {
                return;
            }
            this.actionListeners.removeElement(actionListener2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllActionListeners() {
        if (this.actionListeners == null) {
            return;
        }
        Vector<ActionListener> vector = this.actionListeners;
        synchronized (vector) {
            this.actionListeners.removeAllElements();
            this.actionListeners = null;
        }
    }

    @Override
    public void end() {
        this.clearScreen();
        this.removeAllActionListeners();
    }

    @Override
    public void setSecureChar(char c) {
        this.secureChar = c;
        this.secureCharSet = true;
    }

    @Override
    public char getSecureChar() {
        if (this.secureCharSet) {
            return this.secureChar;
        }
        String string2 = Utilities.getParameter("SECURE-CHAR");
        if (string2 == null || string2.length() != 1) {
            return '*';
        }
        return string2.charAt(0);
    }

    @Override
    public void setAttributes(int n, int n2, int n3) {
        Color color2;
        int n4;
        Color color3;
        if (n2 == 2) {
            n2 = this.defaultFG;
        }
        if (n3 == 0) {
            n3 = this.defaultBG;
        }
        this.curAttr = n;
        n = n & 0x51FFFCBC & 0xFF003FFF;
        if (n2 >= 0 && n2 < 16) {
            n |= n2 << 14 | 0x800000;
        }
        if (n3 >= 0 && n3 < 16) {
            n |= n3 << 18 | 0x400000;
        }
        if ((n & 0x1000) != 0 != this.reverseMode) {
            boolean bl = this.reverseMode = !this.reverseMode;
            if (this.reverseMode) {
                this.reverseIt = true;
            }
            if (debugMode) {
                GFXHandler.debug("reverseMode=" + this.reverseMode);
            }
        }
        if (this.reverseIt && !this.reverseMode) {
            this.reverseIt = false;
            color3 = this.curBG;
            this.curBG = this.curFG;
            this.curFG = color3;
            n4 = this.curIndexBG;
            this.curIndexBG = this.curIndexFG;
            this.curIndexFG = n4;
            if (debugMode) {
                GFXHandler.debug("xxxx   REVERSE MODE OFF, curFG=" + this.curFG + ", curBG=" + this.curBG);
            }
        }
        if ((n & 0x800000) > 0 && this.curIndexFG != n2) {
            this.curIndexFG = n2;
            color2 = ScreenProperty.getColorObject(n2);
            if (color2 != null) {
                this.curFG = color2;
            }
        }
        if ((n & 0x400000) > 0 && this.curIndexBG != n3) {
            this.curIndexBG = n3;
            color2 = ScreenProperty.getColorObject(n3);
            if (color2 != null) {
                this.curBG = color2;
            }
        }
        if (this.reverseIt && this.reverseMode) {
            color3 = this.curBG;
            this.curBG = this.curFG;
            this.curFG = color3;
            n4 = this.curIndexBG;
            this.curIndexBG = this.curIndexFG;
            this.curIndexFG = n4;
            if (debugMode) {
                GFXHandler.debug("xxxx   REVERSE MODE ON, curFG=" + this.curFG + ", curBG=" + this.curBG);
            }
        }
        if ((n & 0x2000) != 0 != this.underlineMode) {
            this.underlineMode = !this.underlineMode;
        }
        if ((n & 0x40000000) != 0 != this.leftlineMode) {
            this.leftlineMode = !this.leftlineMode;
        }
        if ((n & 0x1000000) != 0 != this.overlineMode) {
            this.overlineMode = !this.overlineMode;
        }
        if ((n & 0x10000000) != 0 != this.gridlineMode) {
            this.gridlineMode = !this.gridlineMode;
        }
        if ((n & 0x400) != 0 != this.highlightMode) {
            boolean bl = this.highlightMode = !this.highlightMode;
        }
        if (this.highlightMode) {
            if (this.curFont != this.boldFont) {
                this.curFont = this.boldFont;
            }
        } else if (this.curFont != this.plainFont) {
            this.curFont = this.plainFont;
        }
    }

    @Override
    public void clearAttributes() {
        if (debugMode) {
            GFXHandler.debug("Called clearAttributes()");
        }
        this.curAttr = 0;
        this.curIndexFG = this.defaultFG;
        this.curIndexBG = this.defaultBG;
        this.curFG = ScreenProperty.getColorObject(this.defaultFG);
        this.curBG = ScreenProperty.getColorObject(this.defaultBG);
    }

    @Override
    public int getAttributes() {
        return this.curAttr;
    }

    @Override
    public int getFG() {
        return this.curIndexFG;
    }

    @Override
    public int getBG() {
        return this.curIndexBG;
    }

    @Override
    public void setFG(Color color2) {
        int n = -1;
        if (color2 != null) {
            n = ScreenProperty.getClosestColorIndex(color2);
        }
        this.setFG(n);
    }

    @Override
    public void setBG(Color color2) {
        int n = -1;
        if (color2 != null) {
            n = ScreenProperty.getClosestColorIndex(color2);
        }
        this.setBG(n);
    }

    @Override
    public void setFG(int n) {
        this.setAttributes(this.getAttributes(), n, -1);
    }

    @Override
    public void setBG(int n) {
        this.setAttributes(this.getAttributes(), -1, n);
    }

    @Override
    public int getDefaultFG() {
        return this.defaultFG;
    }

    @Override
    public int getDefaultBG() {
        return this.defaultBG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Dimension dimension = this.pSize;
        synchronized (dimension) {
            return this.pSize;
        }
    }

    public Dimension getSize() {
        return this.getPreferredSize();
    }

    static {
        block4: {
            debugMode = false;
            try {
                String string2 = Utilities.getParameter("java.version");
                int n = 0;
                if (string2 == null) break block4;
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (c < '0' || c > '9') continue;
                    if (++n == 1 && c == '1') {
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        defaultFontName = null;
        defaultFontWidth = -1;
        defaultFontWidthMin = -1;
        defaultFontWidthMax = -1;
        defaultFontWidthMult = 1.0;
    }

    class font {
        private Font myFont;
        private FontMetrics metrics;
        private int height;
        private int width;
        private int descent;
        private int leading;
        private int gap;
        private boolean bold;
        private int size;

        public String toString() {
            return "" + this.myFont;
        }

        private int getMaxAdvance(FontMetrics fontMetrics) {
            if (defaultFontWidth > 2) {
                if (defaultFontWidthMin != -1 && defaultFontWidth < defaultFontWidthMin) {
                    return defaultFontWidthMin;
                }
                if (defaultFontWidthMax != -1 && defaultFontWidth > defaultFontWidthMax) {
                    return defaultFontWidthMax;
                }
                return defaultFontWidth;
            }
            return fontMetrics.charWidth('0');
        }

        private void setupFont(boolean bl, int n) {
            this.bold = bl;
            if (defaultFontName == null) {
                String string2;
                String string3 = null;
                String string4 = null;
                try {
                    string3 = Utilities.getParameter("user.region");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string3 == null) {
                    string3 = "US";
                }
                try {
                    string4 = Utilities.getParameter("user.language");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (string4 == null) {
                    string4 = "en";
                }
                try {
                    defaultFontName = Utilities.getParameter("console_font_" + string4 + "_" + string3);
                    if (defaultFontName == null) {
                        defaultFontName = Utilities.getParameter("console_font_" + string4);
                    }
                    if (defaultFontName == null) {
                        defaultFontName = Utilities.getParameter("console_font");
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                String string5 = Utilities.getParameter("console_width");
                String string6 = Utilities.getParameter("console_width_max");
                String string7 = Utilities.getParameter("console_width_min");
                String string8 = Utilities.getParameter("console_width_mult");
                try {
                    string2 = Utilities.getParameter("console_" + string4 + "_" + string3);
                    if (string2 == null) {
                        string2 = Utilities.getParameter("console_" + string4);
                    }
                    if (string2 == null) {
                        string2 = Utilities.getParameter("console");
                    }
                    if (string2 != null) {
                        int n2;
                        int n3 = 0;
                        do {
                            String string9;
                            if ((n2 = string2.indexOf(44)) >= 0) {
                                try {
                                    string9 = string2.substring(0, n2);
                                    string2 = string2.substring(n2 + 1);
                                }
                                catch (Exception exception) {
                                    string9 = null;
                                    string2 = null;
                                }
                            } else {
                                string9 = string2;
                                string2 = null;
                            }
                            ++n3;
                            if (string9 == null || (string9 = string9.trim()).length() <= 0) continue;
                            switch (n3) {
                                case 0: {
                                    break;
                                }
                                case 1: {
                                    string5 = string9;
                                    break;
                                }
                                case 2: {
                                    string7 = string9;
                                    break;
                                }
                                case 3: {
                                    string6 = string9;
                                    break;
                                }
                                case 4: {
                                    string8 = string9;
                                    break;
                                }
                                case 5: {
                                    defaultFontName = string9;
                                }
                            }
                        } while (n2 >= 0);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (string8 != null) {
                    defaultFontWidthMult = Double.valueOf(string8.trim());
                }
                if (string5 != null && (defaultFontWidth = Utilities.parseInt(string5.trim())) < 3) {
                    defaultFontWidth = -1;
                }
                if (string6 != null && (defaultFontWidthMax = Utilities.parseInt(string6.trim())) < 1) {
                    defaultFontWidthMax = -1;
                }
                if (string7 != null && (defaultFontWidthMin = Utilities.parseInt(string7.trim())) < 1) {
                    defaultFontWidthMin = -1;
                }
                if (defaultFontName == null) {
                    try {
                        string2 = Utilities.getParameter("java.vendor");
                        if (string2 != null && (string2 = string2.toUpperCase()).startsWith("MICROSOFT")) {
                            defaultFontName = "Courier";
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (defaultFontName == null) {
                        defaultFontName = GFXHandler.preferredFontName;
                    }
                }
            }
            this.myFont = bl ? new Font(defaultFontName, 1, n) : new Font(defaultFontName, 0, n);
        }

        private void setupMetrics(FontMetrics fontMetrics) {
            if (this.myFont == null) {
                return;
            }
            this.size = this.myFont.getSize();
            this.height = fontMetrics.getHeight();
            this.descent = fontMetrics.getDescent();
            this.leading = fontMetrics.getLeading();
            this.gap = this.descent;
            this.width = this.getMaxAdvance(fontMetrics);
        }

        public font(int n, boolean bl, Graphics graphics) {
            try {
                this.setupFont(bl, n);
                this.metrics = graphics.getFontMetrics(this.myFont);
                this.setupMetrics(this.metrics);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public font(int n, boolean bl, Component component) {
            try {
                this.setupFont(bl, n);
                if (component.getGraphics() != null) {
                    this.metrics = component.getGraphics().getFontMetrics(this.myFont);
                    this.setupMetrics(this.metrics);
                } else {
                    BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    this.metrics = graphics2D.getFontMetrics(this.myFont);
                    graphics2D.dispose();
                    bufferedImage = null;
                    this.setupMetrics(this.metrics);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setFont(Graphics graphics) {
            graphics.setFont(this.myFont);
        }

        public void setFont(Component component) {
            if (debugMode) {
                GFXHandler.debug("Called setFont(Component=" + component + ")");
            }
            component.setFont(this.myFont);
            if (debugMode) {
                GFXHandler.debug("Done with setFont(..)");
            }
        }

        public Font getFont() {
            return this.myFont;
        }

        public final int getCharCellsOccupied(char c, int n) {
            try {
                if (this.getCharWidth(c) > n) {
                    return 2;
                }
                return 1;
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public final int getCharWidth(char c) {
            if (this.metrics == null) {
                return -1;
            }
            return this.metrics.charWidth(c);
        }

        public final int getCharCellsOccupied(String string2, int n) {
            try {
                return (int)Math.ceil((double)this.getStringWidth(string2) / (double)n);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public final int getStringWidth(String string2) {
            if (this.metrics == null) {
                return -1;
            }
            return this.metrics.stringWidth(string2);
        }

        public int getSize() {
            return this.size;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getDescent() {
            return this.descent;
        }

        public int getLeading() {
            return this.leading;
        }

        public int getGap() {
            return this.gap;
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isPlain() {
            return !this.bold;
        }
    }

    public class GFXHandlerField {
        private String name = null;
        private boolean isField = false;
        private String text = null;
        private int textColumns = 0;
        private Rectangle bounds = null;
        private Component c = null;
        private boolean isJFC = true;
        private Color curFG = null;
        private Color curBG = null;

        GFXHandlerField(String string2, boolean bl, String string3, int n, int n2, int n3, int n4, int n5, boolean bl2, Color color2, Color color3) {
            this.name = string2;
            this.isField = bl;
            this.text = string3;
            this.textColumns = n;
            this.bounds = new Rectangle(n2, n3, n4, n5);
            this.isJFC = bl2;
            this.curFG = color2;
            this.curBG = color3;
        }

        String getName() {
            return this.name;
        }

        void setName(String string2) {
            this.name = string2;
        }

        boolean isField() {
            return this.isField;
        }

        void setField(boolean bl) {
            this.isField = bl;
        }

        String getText() {
            return this.text;
        }

        void setText(String string2) {
            this.text = string2;
        }

        int getTextColumns() {
            return this.textColumns;
        }

        void setTextColumns(int n) {
            this.textColumns = n;
        }

        Rectangle getBounds() {
            return this.bounds;
        }

        void setBounds(Rectangle rectangle) {
            this.bounds = rectangle;
        }

        Color getFG() {
            return this.curFG;
        }

        void setFG(Color color2) {
            this.curFG = color2;
        }

        Color getBG() {
            return this.curBG;
        }

        void setBG(Color color2) {
            this.curBG = color2;
        }

        void setJFC(boolean bl) {
            this.isJFC = bl;
        }

        boolean isJFC() {
            return this.isJFC;
        }

        Component getComponent() {
            if (this.c == null) {
                this.createComponent();
            }
            return this.c;
        }

        private void createComponent() {
            if (this.isJFC) {
                if (this.isField) {
                    try {
                        JPasswordField jPasswordField = new JPasswordField(this.text, this.textColumns){

                            @Override
                            public boolean isManagingFocus() {
                                return true;
                            }

                            @Override
                            protected void processComponentKeyEvent(KeyEvent keyEvent) {
                                try {
                                    switch (keyEvent.getKeyCode()) {
                                        case 9: {
                                            keyEvent.consume();
                                            return;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                super.processComponentKeyEvent(keyEvent);
                            }
                        };
                        ((JPasswordField)jPasswordField).setEchoChar('\u0000');
                        jPasswordField.getUI().getRootView(jPasswordField).getPreferredSpan(1);
                        this.c = jPasswordField;
                    }
                    catch (Exception exception) {}
                } else {
                    try {
                        JLabel jLabel = new JLabel(this.text);
                        jLabel.setOpaque(true);
                        this.c = jLabel;
                        this.c.setForeground(this.curFG);
                        this.c.setBackground(this.curBG);
                    }
                    catch (Exception exception) {}
                }
            } else if (this.isField) {
                try {
                    this.c = new TextField(this.text, this.textColumns);
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.c = new Label(this.text);
                    this.c.setForeground(this.curFG);
                    this.c.setBackground(this.curBG);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.c != null) {
                GFXHandler.this.curFont.setFont(this.c);
                this.c.setName(this.name);
                this.c.setBounds(this.bounds);
            }
        }
    }
}

