/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.term;

import com.heirloomcomputing.term.Field;
import com.heirloomcomputing.term.FieldException;
import com.heirloomcomputing.term.Form;
import com.heirloomcomputing.term.KeyValue;
import com.heirloomcomputing.term.Text;
import com.heirloomcomputing.term.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class GraphicsForm
extends Form
implements ActionListener,
KeyListener {
    private static final Color ERROR_BG_COLOR = new Color(255, 100, 100);
    private JComponent parent;
    private JPanel container;
    private Font containerFont;
    private Text errorEnhancement;
    private int cellWidth = 8;
    private int cellHeight = 12;
    private JMenu optionsMenu;
    private KeyValue lastKey;
    private final Object lastKeyLock = new Object();
    private Component glassPane;

    public GraphicsForm(JComponent jComponent, int n, int n2) {
        this(jComponent, null, n, n2);
    }

    public GraphicsForm(JComponent jComponent, Font font2, int n, int n2) {
        this.parent = jComponent;
        this.containerFont = font2;
        this.setDisplaySize(new Dimension(n2, n));
    }

    private JPanel createFormContainer(JComponent jComponent, Font font2) {
        if (jComponent == null) {
            return null;
        }
        JPanel jPanel = new JPanel(){

            @Override
            public boolean isFocusCycleRoot() {
                return true;
            }

            @Override
            public boolean isFocusTraversable() {
                return false;
            }
        };
        Graphics graphics = jComponent.getGraphics();
        if (font2 == null) {
            font2 = graphics.getFont();
        }
        jPanel.setFont(font2);
        FontMetrics fontMetrics = jPanel.getFontMetrics(font2);
        if (fontMetrics.stringWidth("W") != fontMetrics.stringWidth("i")) {
            try {
                font2 = new Font("Courier", 0, 12);
                jPanel.setFont(font2);
                fontMetrics = jPanel.getFontMetrics(font2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Dimension dimension = this.getDisplaySize();
        this.cellWidth = fontMetrics.stringWidth("W");
        this.cellHeight = fontMetrics.getHeight();
        Dimension dimension2 = new Dimension(dimension.width * this.cellWidth, dimension.height * this.cellHeight);
        jPanel.setPreferredSize(dimension2);
        jComponent.setLayout(new BorderLayout(0, 0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, "West");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, "North");
        jComponent.add((Component)jPanel3, "Center");
        jPanel.setLayout(null);
        jPanel.setCursor(Cursor.getDefaultCursor());
        return jPanel;
    }

    public void turnOff() {
        if (this.container != null) {
            try {
                this.container.getParent().getParent().setVisible(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void turnOn() {
        if (this.container != null) {
            try {
                this.container.getParent().getParent().setVisible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Rectangle getTextBounds(Text text) {
        Rectangle rectangle = new Rectangle();
        Point point = text.getLocation();
        rectangle.x = point.x * this.cellWidth;
        rectangle.y = point.y * this.cellHeight;
        rectangle.width = this.cellWidth * text.getDisplayLength();
        rectangle.height = this.cellHeight;
        return rectangle;
    }

    private Font getFont(Font font2, Text text) {
        return this.getFont(font2, text, false);
    }

    private Font getFont(Font font2, Text text, boolean bl) {
        if (text.isBlink() || bl) {
            Font font3 = new Font(font2.getName(), font2.getStyle() | 2, font2.getSize());
            return font3;
        }
        if (text instanceof Field) {
            Field field = (Field)text;
            if (field.isError() && this.errorEnhancement != null) {
                return this.getFont(font2, this.errorEnhancement);
            }
        } else if (text.isReversedImage() || bl) {
            Font font4 = new Font(font2.getName(), font2.getStyle() | 1, font2.getSize());
            return font4;
        }
        return font2;
    }

    private void drawText(Text[] textArray) {
        this.drawText(textArray, false);
    }

    private void drawText(Text[] textArray, boolean bl) {
        if (this.container == null || textArray == null) {
            return;
        }
        for (final Text text : textArray) {
            int n = text.getDisplayLength();
            String string2 = text.getDisplayValue();
            if (text.isNonDisplay()) {
                string2 = "";
            }
            if (!bl) {
                while (string2.length() < n) {
                    string2 = string2 + "                              ";
                }
                if (n > 0 && string2.length() > n) {
                    string2 = string2.substring(0, n);
                }
            } else {
                string2 = string2.trim();
            }
            try {
                JLabel jLabel = new JLabel(string2){

                    @Override
                    public void paintComponent(Graphics graphics) {
                        super.paintComponent(graphics);
                        if (!text.isUnderlined()) {
                            return;
                        }
                        Rectangle rectangle = this.getBounds();
                        rectangle.x = 0;
                        rectangle.y = 0;
                        int n = rectangle.y + rectangle.height - 2;
                        graphics.drawLine(rectangle.x, n, rectangle.x + rectangle.width - 4, n);
                    }
                };
                if (bl) {
                    jLabel.setBorder(BorderFactory.createLoweredBevelBorder());
                    jLabel.setForeground(SystemColor.infoText);
                    jLabel.setBackground(SystemColor.info);
                    jLabel.setOpaque(true);
                }
                Rectangle rectangle = this.getTextBounds(text);
                jLabel.setBounds(rectangle);
                this.container.add(jLabel);
                jLabel.setFont(this.getFont(this.container.getFont(), text, bl));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void drawFields(Field[] fieldArray) {
        if (this.container == null || fieldArray == null) {
            return;
        }
        for (Field field : fieldArray) {
            int n = field.getDisplayLength();
            String string2 = field.getDisplayValue();
            if (field.isNonDisplay()) {
                string2 = "";
            }
            while (string2.length() < n) {
                string2 = string2 + "                              ";
            }
            if (n > 0 && string2.length() > n) {
                string2 = string2.substring(0, n);
            }
            try {
                Object object;
                JTextField jTextField = null;
                jTextField = !field.isSecure() ? new JTextField(string2.trim()){

                    @Override
                    public boolean isFocusTraversable() {
                        return this.isEditable();
                    }
                } : new JPasswordField(string2.trim()){

                    @Override
                    public boolean isFocusTraversable() {
                        return this.isEditable();
                    }
                };
                if (!field.isEditable()) {
                    jTextField.setEditable(false);
                }
                if (field.isError()) {
                    jTextField.setBackground(ERROR_BG_COLOR);
                    jTextField.setForeground(Color.white);
                    object = field.getErrorMessage();
                    if (object != null) {
                        jTextField.setToolTipText((String)object);
                    } else {
                        String string3 = field.getEditMask();
                        if (string3 != null) {
                            jTextField.setToolTipText(string3);
                        }
                    }
                } else {
                    object = field.getEditMask();
                    if (object != null) {
                        jTextField.setToolTipText((String)object);
                    }
                }
                object = this.getTextBounds(field);
                ((Rectangle)object).x -= this.cellWidth;
                ((Rectangle)object).width += this.cellWidth * 2;
                jTextField.setBounds((Rectangle)object);
                this.container.add(jTextField);
                jTextField.setFont(this.getFont(this.container.getFont(), field));
                jTextField.setColumns(field.getDisplayLength());
                jTextField.addKeyListener(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getButtonText(String string2, String string3, int n) {
        string2 = string2.trim();
        string3 = string3.trim();
        String string4 = (string2 + " " + string3).trim();
        return string4;
    }

    private String getOptionsMenuText() {
        return Utilities.getParameter("OPTIONS_MENU_TEXT");
    }

    private void drawFunctionKeys(Text[] textArray, Text[] textArray2) {
        int n;
        if (this.container == null || textArray == null) {
            return;
        }
        int n2 = textArray.length;
        if (n2 == 0) {
            return;
        }
        JRootPane jRootPane = this.container.getRootPane();
        JMenuBar jMenuBar = null;
        boolean bl = false;
        if (jRootPane != null && Utilities.getParameter("DISABLE_OPTIONS_MENU") == null) {
            jMenuBar = jRootPane.getJMenuBar();
            if (jMenuBar == null) {
                jMenuBar = new JMenuBar();
                bl = true;
            }
            if (this.optionsMenu == null) {
                String string2 = this.getOptionsMenuText();
                char c = '\u0000';
                if (string2 == null) {
                    string2 = "&Options";
                }
                if ((n = string2.indexOf(38)) >= 0) {
                    try {
                        c = string2.charAt(n + 1);
                        string2 = n == 0 ? string2.substring(n + 1) : string2.substring(0, n) + string2.substring(n + 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.optionsMenu = new JMenu(string2);
                if (c != '\u0000') {
                    this.optionsMenu.setMnemonic(c);
                }
                jMenuBar.add(this.optionsMenu);
            } else {
                this.optionsMenu.removeAll();
            }
        }
        for (int i = 0; i < n2; ++i) {
            Text text = textArray[i];
            n = text.getDisplayLength();
            String string3 = text.getDisplayValue();
            if (text.isNonDisplay()) {
                string3 = "";
            }
            while (string3.length() < n) {
                string3 = string3 + "                              ";
            }
            if (n > 0 && string3.length() > n) {
                string3 = string3.substring(0, n);
            }
            String string4 = textArray2[i].getDisplayValue();
            if (text.isNonDisplay()) {
                string4 = "";
            }
            while (string4.length() < n) {
                string4 = string4 + "                              ";
            }
            if (n > 0 && string4.length() > n) {
                string4 = string4.substring(0, n);
            }
            try {
                String string5 = this.getButtonText(string3, string4, i + 1);
                final String string6 = string3;
                final String string7 = string4;
                JButton jButton = new JButton(){

                    @Override
                    public void paintComponent(Graphics graphics) {
                        super.paintComponent(graphics);
                        Rectangle rectangle = this.getBounds();
                        rectangle.x = 0;
                        rectangle.y = 0;
                        int n = rectangle.y + rectangle.height / 2;
                        int n2 = n / 4;
                        graphics.drawString(string6, 2, n - n2);
                        graphics.drawString(string7, 2, n + GraphicsForm.this.cellHeight - n2 - 2);
                    }
                };
                if (string5.length() == 0) {
                    jButton.setEnabled(false);
                }
                Rectangle rectangle = this.getTextBounds(text);
                rectangle.x = rectangle.x - this.cellWidth / 2 + 1;
                rectangle.width = rectangle.width + this.cellWidth - 1;
                rectangle.height *= 2;
                jButton.setBounds(rectangle);
                this.container.add(jButton);
                jButton.setFont(this.getFont(this.container.getFont(), text));
                jButton.setDefaultCapable(false);
                jButton.setActionCommand("FK" + (i + 1));
                jButton.addActionListener(this);
                jButton.setToolTipText(string5);
                jButton.addKeyListener(this);
                if (this.optionsMenu == null || !jButton.isEnabled()) continue;
                JMenuItem jMenuItem = new JMenuItem(string5);
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112 + i, 0));
                jMenuItem.setActionCommand(jButton.getActionCommand());
                jMenuItem.addActionListener(this);
                jMenuItem.setToolTipText(string5);
                this.optionsMenu.add(jMenuItem);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            jRootPane.setJMenuBar(jMenuBar);
            Container container = jRootPane.getTopLevelAncestor();
            if (container instanceof Window) {
                try {
                    ((Window)container).pack();
                }
                catch (Exception exception) {}
            } else {
                try {
                    jRootPane.revalidate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void putErrorMessage(Text text) {
        this.drawText(new Text[]{text}, true);
    }

    private void clearForm() {
        if (this.container == null) {
            return;
        }
        try {
            this.container.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void beep() {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void refresh() {
        if (this.container == null) {
            return;
        }
        try {
            this.container.revalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.container.repaint();
    }

    private JTextField getJTextField(Field field) {
        if (field == null) {
            return null;
        }
        Rectangle rectangle = this.getTextBounds(field);
        return this.getJTextField(rectangle.x, rectangle.y);
    }

    private JTextField getJTextField(int n, int n2) {
        Component component = this.container.getComponentAt(n, n2);
        if (component instanceof JTextField) {
            return (JTextField)component;
        }
        return null;
    }

    private void placeFocusOnFieldAtCursorPosition() {
        this.placeFocusOnFieldAtCursorPosition(false);
    }

    private void placeFocusOnFieldAtCursorPosition(boolean bl) {
        Point point = this.getCursorLocation();
        JTextField jTextField = this.getJTextField(this.getField(point));
        if (jTextField == null) {
            return;
        }
        jTextField.requestFocus();
        if (bl) {
            jTextField.selectAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showForm(boolean bl, boolean bl2, Text[] textArray, Text[] textArray2, Text text) {
        if (this.container == null) {
            this.container = this.createFormContainer(this.parent, this.containerFont);
        }
        this.setBusy(false);
        this.errorEnhancement = text;
        this.clearForm();
        Object object = this.container.getTreeLock();
        synchronized (object) {
            this.drawFunctionKeys(textArray, textArray2);
            this.drawFields(this.getFields());
            this.drawText(this.getText());
            Text text2 = this.getStatus();
            if (text2 != null) {
                this.putErrorMessage(text2);
            }
            this.refresh();
        }
        this.placeFocusOnFieldAtCursorPosition();
        if (bl2) {
            this.beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int readField(int n, Object[] objectArray) throws FieldException {
        Object object;
        int n2;
        this.setBusy(false);
        int n3 = this.getNumberOfFields();
        Field field = null;
        if (n3 > 0) {
            field = this.getField(n);
        }
        KeyValue keyValue = null;
        if (field == null) {
            this.waitForTerminator((KeyValue[])objectArray);
        } else {
            n2 = field.getDisplayLength();
            if (!field.isEditable() || n2 == 0) {
                n = n == -n3 ? -1 : --n;
                return n;
            }
            Point point = field.getLocation();
            this.setCursorLocation(new Point(point.x, point.y));
            this.placeFocusOnFieldAtCursorPosition(true);
            object = this.lastKeyLock;
            synchronized (object) {
                try {
                    this.lastKeyLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                keyValue = this.lastKey;
            }
        }
        try {
            n2 = -this.getNumberOfFields();
            for (int i = -1; i >= n2; --i) {
                object = this.getField(i);
                JTextField jTextField = this.getJTextField((Field)object);
                if (jTextField == null) continue;
                String string2 = null;
                if (jTextField instanceof JPasswordField) {
                    char[] cArray = ((JPasswordField)jTextField).getPassword();
                    if (cArray != null) {
                        string2 = new String(cArray);
                    }
                } else {
                    string2 = jTextField.getText();
                }
                if (string2 == null) continue;
                object.setValue(string2);
                object.setDirty(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        final KeyValue keyValue2 = keyValue;
        this.setBusy(true);
        throw new FieldException(){

            @Override
            public boolean getTerminatorPressed() {
                return true;
            }

            @Override
            public Object getTerminator() {
                return keyValue2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object waitForTerminator(Object[] objectArray) {
        Object object = this.lastKeyLock;
        synchronized (object) {
            try {
                this.lastKeyLock.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.lastKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            return;
        }
        String string2 = actionEvent.getActionCommand();
        if (string2.startsWith("FK") && string2.length() > 2) {
            int n = string2.charAt(2) - 48;
            Object object = this.lastKeyLock;
            synchronized (object) {
                this.lastKey = new KeyValue(n + 112 - 1, 0);
                try {
                    this.lastKeyLock.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            Object object = this.lastKeyLock;
            synchronized (object) {
                this.lastKey = new KeyValue('\n', 10, 0);
                try {
                    this.lastKeyLock.notifyAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void setBusy(boolean bl) {
        try {
            Window window = SwingUtilities.windowForComponent(this.container);
            if (this.glassPane == null) {
                JRootPane jRootPane = this.container.getRootPane();
                this.glassPane = jRootPane.getGlassPane();
                this.glassPane.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent keyEvent) {
                        keyEvent.consume();
                    }

                    @Override
                    public void keyPressed(KeyEvent keyEvent) {
                        keyEvent.consume();
                    }

                    @Override
                    public void keyReleased(KeyEvent keyEvent) {
                        keyEvent.consume();
                    }
                });
                this.glassPane.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        mouseEvent.consume();
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        mouseEvent.consume();
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        mouseEvent.consume();
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                        mouseEvent.consume();
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                        mouseEvent.consume();
                    }
                });
            }
            if (bl) {
                window.setCursor(Cursor.getPredefinedCursor(3));
                this.glassPane.setVisible(true);
                this.glassPane.requestFocus();
                this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                this.glassPane.setCursor(Cursor.getDefaultCursor());
                this.glassPane.setVisible(false);
                window.requestFocus();
                window.setCursor(Cursor.getDefaultCursor());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

