/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecc;

import com.heirloomcomputing.ecc.IRAC;
import com.heirloomcomputing.ecc.RACFactory;
import com.heirloomcomputing.ecc.RACRole;
import com.heirloomcomputing.ecc.RACUser;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class RACLogon
implements LoginModule {
    private static RACLogon globalRACLogon;
    private CallbackHandler handler;
    private Subject subject;
    private RACUser userLogon;
    private List<RACRole> rolesLogon;
    private String login;
    private List<String> userGroups;
    private IRAC ourRAC;

    public RACLogon() {
        globalRACLogon = this;
        this.ourRAC = RACFactory.getRAC(null, null);
    }

    public static RACLogon getGlobalRACLogon() {
        return globalRACLogon;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> map, Map<String, ?> map2) {
        this.handler = callbackHandler;
        this.subject = subject;
        this.rolesLogon = new ArrayList<RACRole>();
    }

    @Override
    public boolean login() throws LoginException {
        if (!this.ourRAC.IsRACon()) {
            this.ourRAC.TearDown();
            throw new LoginException("Authentication failed - security server not available");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("login"), new PasswordCallback("password", true)};
        try {
            this.handler.handle(callbackArray);
            String string = ((NameCallback)callbackArray[0]).getName();
            String string2 = String.valueOf(((PasswordCallback)callbackArray[1]).getPassword());
            this.userGroups = this.ourRAC.Authenticate(string, string2);
            if (this.userGroups != null) {
                this.login = string;
                return true;
            }
            throw new LoginException("Authentication failed - user/password does not match");
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.getMessage());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException(unsupportedCallbackException.getMessage());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        this.userLogon = new RACUser(this.login);
        this.subject.getPrincipals().add(this.userLogon);
        if (this.userGroups != null && this.userGroups.size() > 0) {
            for (String object : this.userGroups) {
                RACRole rACRole2 = new RACRole(object);
                this.rolesLogon.add(rACRole2);
                this.subject.getPrincipals().add((Principal)((Object)rACRole2));
            }
            RACRole rACRole = new RACRole("Roles");
            for (RACRole rACRole2 : this.rolesLogon) {
                rACRole.addMember((Principal)((Object)rACRole2));
            }
            this.subject.getPrincipals().add((Principal)((Object)rACRole));
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userLogon);
        for (RACRole rACRole : this.rolesLogon) {
            this.subject.getPrincipals().remove(rACRole);
        }
        this.subject.getPrincipals().remove("Roles");
        this.userLogon = null;
        this.rolesLogon.clear();
        return true;
    }

    public String toString() {
        String string = "RACLogon(";
        string = this.userLogon != null ? string + this.userLogon.toString() : string + "<unknown user>";
        if (this.rolesLogon != null) {
            string = string + ", {";
            Iterator<RACRole> iterator = this.rolesLogon.iterator();
            while (iterator.hasNext()) {
                RACRole rACRole = iterator.next();
                if (rACRole != null) {
                    string = string + rACRole.toString();
                }
                if (!iterator.hasNext()) continue;
                string = string + ",";
            }
            string = string + "}";
        } else {
            string = string + "<unknown roles>";
        }
        string = string + ")";
        return string;
    }
}

