/*
 * Decompiled with CFR 0.152.
 */
package com.heirloomcomputing.ecc;

import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.InvalidSearchControlsException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class RACLookup {
    public static Logger LOGGER = null;
    private String authentication = null;
    private String connectionName = null;
    private String connectionPassword = null;
    private String connectionURL = null;
    private DirContext context = null;
    private String contextFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private String protocol = null;
    private String userBase = "";
    private String userSearch = null;
    private boolean userSearchAsUser = false;
    private MessageFormat userSearchFormat = null;
    private boolean userSubtree = false;
    private String userPassword = null;
    private String userRoleAttribute = null;
    private String[] userPatternArray = null;
    private String userPattern = null;
    private MessageFormat[] userPatternFormatArray = null;
    private String opidAttribute = "o";
    private String resourceName = "";
    private String resourceBase = "";
    private MessageFormat resourceBaseFormat = null;
    private String resourceMemberAttribute = null;
    private String resourceRuleAttribute = null;
    private boolean resourceSearchAsUser = false;
    private String[] resourceTypes = new String[]{"datasets", "jobclasses", "outputclasses", "transactions", "programs"};
    private String resourceGroupBase = "";
    private MessageFormat resourceGroupBaseFormat = null;
    private String resourceGroupName = null;
    private String resourceGroupMemberAttribute = null;
    private String resourceGroupRuleAttribute = null;
    private String roleBase = "";
    private MessageFormat roleBaseFormat = null;
    private MessageFormat roleFormat = null;
    private String userRoleName = null;
    private String roleName = null;
    private String roleSearch = null;
    private boolean roleSubtree = false;
    private boolean roleNested = false;
    private boolean roleSearchAsUser = false;
    private String alternateURL = null;
    private int connectionAttempt = 0;
    private String commonRole = null;
    private String connectionTimeout = "5000";
    private long sizeLimit = 0L;
    private int timeLimit = 0;
    private boolean debug = false;
    private int cacheTime = 480;
    private int cacheSize = 5000;
    private static final int groupMembersRangeSize = 1000;
    private static final Pattern commaSplitPtr = Pattern.compile(",");
    private static final Pattern equalSignSplitPtr = Pattern.compile("=");
    private static HashMap<String, AuthenticatedUser> cachedUsers = new HashMap();
    private static HashMap<String, AuthorizedResource> cachedResources = new HashMap();
    private static Date GlobalUserExpiredDate = new Date();
    private static Date GlobalResourceExpiredDate = new Date();
    private static final AuthorizedResource NotFoundResource = new AuthorizedResource(0, null, null, null, null, null, null);

    public RACLookup() {
        LOGGER = Logger.getLogger("RAC");
        cachedUsers.clear();
        cachedResources.clear();
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public void setAuthentication(String string) {
        this.authentication = string;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionPassword() {
        return this.connectionPassword;
    }

    public void setConnectionPassword(String string) {
        this.connectionPassword = string;
    }

    public String getConnectionURL() {
        return this.connectionURL;
    }

    public void setConnectionURL(String string) {
        this.connectionURL = string;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(String string) {
        this.contextFactory = string;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public String getUserBase() {
        return this.userBase;
    }

    public void setUserBase(String string) {
        this.userBase = string;
    }

    public String getUserSearch() {
        return this.userSearch;
    }

    public void setUserSearch(String string) {
        this.userSearch = string;
        this.userSearchFormat = string == null ? null : new MessageFormat(string);
    }

    public boolean isUserSearchAsUser() {
        return this.userSearchAsUser;
    }

    public void setUserSearchAsUser(boolean bl) {
        this.userSearchAsUser = bl;
    }

    public boolean isUserSubtree() {
        return this.userSubtree;
    }

    public void setUserSubtree(boolean bl) {
        this.userSubtree = bl;
    }

    public String getUserRoleName() {
        return this.userRoleName;
    }

    public void setUserRoleName(String string) {
        this.userRoleName = string;
    }

    public String getResourceName() {
        return this.resourceBase;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String string) {
        this.resourceBase = string;
        this.resourceBaseFormat = string == null ? null : new MessageFormat(string);
    }

    public String getResourceMemberAttribute() {
        return this.resourceMemberAttribute;
    }

    public void setResourceMemberAttribute(String string) {
        this.resourceMemberAttribute = string;
    }

    public String getResourceRuleAttribute() {
        return this.resourceRuleAttribute;
    }

    public void setResourceRuleAttribute(String string) {
        this.resourceRuleAttribute = string;
    }

    public boolean isResourceSearchAsUser() {
        return this.resourceSearchAsUser;
    }

    public void setResourceSearchAsUser(boolean bl) {
        this.resourceSearchAsUser = bl;
    }

    public String[] getResourceTypes() {
        return this.resourceTypes;
    }

    public void setResourceTypes(String[] stringArray) {
        this.resourceTypes = stringArray;
    }

    public String getResourceGroupBase() {
        return this.resourceGroupBase;
    }

    public void setResourceGroupBase(String string) {
        this.resourceGroupBase = string;
        this.resourceGroupBaseFormat = string == null ? null : new MessageFormat(string);
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public void setResourceGroupName(String string) {
        this.resourceGroupName = string;
    }

    public String getResourceGroupMemberAttribute() {
        return this.resourceGroupMemberAttribute;
    }

    public void setResourceGroupMemberAttribute(String string) {
        this.resourceGroupMemberAttribute = string;
    }

    public String getResourceGroupRuleAttribute() {
        return this.resourceGroupRuleAttribute;
    }

    public void setResourceGroupRuleAttribute(String string) {
        this.resourceGroupRuleAttribute = string;
    }

    public String getRoleBase() {
        return this.roleBase;
    }

    public void setRoleBase(String string) {
        this.roleBase = string;
        this.roleBaseFormat = string == null ? null : new MessageFormat(string);
    }

    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(String string) {
        this.roleName = string;
    }

    public String getRoleSearch() {
        return this.roleSearch;
    }

    public void setRoleSearch(String string) {
        this.roleSearch = string;
        this.roleFormat = string == null ? null : new MessageFormat(string);
    }

    public boolean isRoleSearchAsUser() {
        return this.roleSearchAsUser;
    }

    public void setRoleSearchAsUser(boolean bl) {
        this.roleSearchAsUser = bl;
    }

    public boolean isRoleSubtree() {
        return this.roleSubtree;
    }

    public void setRoleSubtree(boolean bl) {
        this.roleSubtree = bl;
    }

    public boolean isRoleNested() {
        return this.roleNested;
    }

    public void setRoleNested(boolean bl) {
        this.roleNested = bl;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(String string) {
        this.userPassword = string;
    }

    public String getUserRoleAttribute() {
        return this.userRoleAttribute;
    }

    public void setUserRoleAttribute(String string) {
        this.userRoleAttribute = string;
    }

    public String getUserPattern() {
        return this.userPattern;
    }

    public void setUserPattern(String string) {
        this.userPattern = string;
        if (string == null) {
            this.userPatternArray = null;
        } else {
            this.userPatternArray = this.parseUserPatternString(string);
            int n = this.userPatternArray.length;
            this.userPatternFormatArray = new MessageFormat[n];
            for (int i = 0; i < n; ++i) {
                this.userPatternFormatArray[i] = new MessageFormat(this.userPatternArray[i]);
            }
        }
    }

    public void setOpidAttribute(String string) {
        this.opidAttribute = string;
    }

    public String getOpidAttribute() {
        return this.opidAttribute;
    }

    public String getAlternateURL() {
        return this.alternateURL;
    }

    public void setAlternateURL(String string) {
        this.alternateURL = string;
    }

    public String getCommonRole() {
        return this.commonRole;
    }

    public void setCommonRole(String string) {
        this.commonRole = string;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String string) {
        this.connectionTimeout = string;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long l) {
        this.sizeLimit = l;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int n) {
        this.timeLimit = n;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public int getCacheTime() {
        return this.cacheTime;
    }

    public void setCacheTime(int n) {
        this.cacheTime = n;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int n) {
        this.cacheSize = n;
    }

    public boolean init() {
        try {
            this.context = this.open();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (this.context == null) {
            try {
                this.context = this.open();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (this.context != null) {
            try {
                if (this.debug) {
                    LOGGER.log(Level.FINEST, "HCI835D", "Test LDAP connection with phony user 'HCIEBP'");
                }
                this.authenticate(this.context, "HCIEBP", "test LDAP communication");
            }
            catch (CommunicationException communicationException) {
                this.context = null;
            }
            catch (NamingException namingException) {
                this.context = null;
            }
        }
        return this.context != null;
    }

    public void finish() {
        if (this.context != null) {
            this.close(this.context);
            this.context = null;
        }
        cachedUsers.clear();
        cachedResources.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberUser(String string, AuthenticatedUser authenticatedUser) {
        HashMap<String, AuthenticatedUser> hashMap;
        string = string.toUpperCase();
        if (this.cacheSize > 0 && cachedResources.size() >= this.cacheSize) {
            hashMap = cachedUsers;
            synchronized (hashMap) {
                long l = 2000000000L;
                String string2 = null;
                Iterator<Map.Entry<String, AuthenticatedUser>> iterator = cachedUsers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, AuthenticatedUser> entry = iterator.next();
                    AuthenticatedUser authenticatedUser2 = entry.getValue();
                    if (authenticatedUser2 == null) {
                        iterator.remove();
                        continue;
                    }
                    if (authenticatedUser2.getLastUsed() >= l) continue;
                    l = authenticatedUser2.getLastUsed();
                    string2 = entry.getKey();
                }
                if (string2 != null) {
                    cachedUsers.remove(string2);
                }
            }
        }
        hashMap = cachedUsers;
        synchronized (hashMap) {
            if (authenticatedUser != null) {
                authenticatedUser.hasBeenUsed();
            }
            cachedUsers.put(string, authenticatedUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticatedUser recallUser(String string, boolean bl) {
        string = string.toUpperCase();
        AuthenticatedUser authenticatedUser = null;
        HashMap<String, AuthenticatedUser> hashMap = cachedUsers;
        synchronized (hashMap) {
            if (cachedUsers.containsKey(string)) {
                authenticatedUser = cachedUsers.get(string);
                if (authenticatedUser != null) {
                    if (bl && authenticatedUser.isExpired(this.cacheTime)) {
                        cachedUsers.remove(string);
                        authenticatedUser = null;
                    } else {
                        authenticatedUser.hasBeenUsed();
                    }
                } else if (RACLookup.isExpired(this.cacheTime, GlobalUserExpiredDate)) {
                    Iterator<Map.Entry<String, AuthenticatedUser>> iterator = cachedUsers.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, AuthenticatedUser> entry = iterator.next();
                        if (entry.getValue() != null) continue;
                        iterator.remove();
                    }
                    GlobalUserExpiredDate = new Date();
                }
            }
        }
        return authenticatedUser;
    }

    public AuthenticatedUser authenticate(String string, String string2) {
        DirContext dirContext = null;
        AuthenticatedUser authenticatedUser = this.recallUser(string, true);
        AuthenticatedUser authenticatedUser2 = authenticatedUser;
        if (authenticatedUser2 != null && string2.equals(authenticatedUser2.password)) {
            if (authenticatedUser2.isAuthenticated()) {
                return authenticatedUser2;
            }
            return null;
        }
        try {
            dirContext = this.open();
            try {
                authenticatedUser2 = this.authenticate(dirContext, string, string2);
            }
            catch (NullPointerException nullPointerException) {
                LOGGER.log(Level.SEVERE, "HCI838E", "Retrying LDAP connection");
                if (dirContext != null) {
                    this.close(dirContext);
                }
                dirContext = this.open();
                authenticatedUser2 = this.authenticate(dirContext, string, string2);
            }
            catch (CommunicationException communicationException) {
                LOGGER.log(Level.SEVERE, "HCI838E", "RAC Exception" + communicationException);
                if (dirContext != null) {
                    this.close(dirContext);
                }
                dirContext = this.open();
                authenticatedUser2 = this.authenticate(dirContext, string, string2);
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                LOGGER.log(Level.SEVERE, "HCI838E", "RAC Exception:" + serviceUnavailableException);
                if (dirContext != null) {
                    this.close(dirContext);
                }
                dirContext = this.open();
                authenticatedUser2 = this.authenticate(dirContext, string, string2);
            }
            this.release(dirContext);
            if (!(authenticatedUser2 != null || authenticatedUser != null && authenticatedUser.isAuthenticated())) {
                authenticatedUser2 = new AuthenticatedUser(string, null, string2, null, null, null);
            }
            this.rememberUser(string, authenticatedUser2);
            if (authenticatedUser2 == null || !authenticatedUser2.isAuthenticated()) {
                return null;
            }
            return authenticatedUser2;
        }
        catch (NamingException namingException) {
            LOGGER.log(Level.SEVERE, "HCI838E", "RAC Exception:" + namingException);
            if (dirContext != null) {
                this.close(dirContext);
            }
            if (this.debug) {
                LOGGER.log(Level.SEVERE, "HCI835D", "Returning null user.");
            }
            return null;
        }
    }

    public AuthorizedResource authorize(String string, List<String> list, int n, String string2, String string3) {
        AuthorizedResource authorizedResource = null;
        AuthenticatedUser authenticatedUser = this.recallUser(string, false);
        try {
            this.context = this.open();
            if (authenticatedUser == null) {
                authenticatedUser = this.getUser(this.context, string, null);
                if (authenticatedUser == null) {
                    authenticatedUser = new AuthenticatedUser(string, null, null, list, null, null);
                }
                this.rememberUser(string, authenticatedUser);
            }
            try {
                authorizedResource = this.authorize(this.context, authenticatedUser, n, string2, string3);
            }
            catch (NullPointerException nullPointerException) {
                LOGGER.log(Level.SEVERE, "HCI838E", "Retrying LDAP connection");
                if (this.context != null) {
                    this.close(this.context);
                }
                this.context = this.open();
                authorizedResource = this.authorize(this.context, authenticatedUser, n, string2, string3);
            }
            catch (CommunicationException communicationException) {
                LOGGER.log(Level.SEVERE, "HCI838E", "RAC Exception" + communicationException);
                if (this.context != null) {
                    this.close(this.context);
                }
                this.context = this.open();
                authorizedResource = this.authorize(this.context, authenticatedUser, n, string2, string3);
            }
            catch (ServiceUnavailableException serviceUnavailableException) {
                LOGGER.log(Level.SEVERE, "HCI838E", "RAC Exception:" + serviceUnavailableException);
                if (this.context != null) {
                    this.close(this.context);
                }
                this.context = this.open();
                authorizedResource = this.authorize(this.context, authenticatedUser, n, string2, string3);
            }
            this.release(this.context);
            return authorizedResource;
        }
        catch (NamingException namingException) {
            if (this.context != null) {
                this.close(this.context);
            }
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "Resource not found in directory.");
            }
            return null;
        }
    }

    public List<String> getRolesForUser(String string) {
        AuthenticatedUser authenticatedUser = cachedUsers.get(string);
        if (authenticatedUser != null) {
            return authenticatedUser.getRoles();
        }
        return null;
    }

    public synchronized AuthenticatedUser authenticate(DirContext dirContext, String string, String string2) throws NamingException {
        if (string == null || string.isEmpty() || string2 == null || string2.isEmpty()) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "username null or empty: returning null principal.");
            }
            return null;
        }
        if (this.userPatternArray != null) {
            for (int i = 0; i < this.userPatternFormatArray.length; ++i) {
                AuthenticatedUser authenticatedUser = this.getUser(dirContext, string, string2, i);
                if (authenticatedUser == null) continue;
                try {
                    if (this.checkCredentials(dirContext, authenticatedUser, string2)) {
                        List<String> list = this.getRoles(dirContext, authenticatedUser);
                        if (list != null && !list.isEmpty()) {
                            if (this.debug) {
                                String string3 = "";
                                for (String string4 : list) {
                                    string3 = string3 + " " + string4;
                                }
                                LOGGER.log(Level.FINEST, "HCI835D", "Found roles:" + string3);
                            }
                        } else if (this.debug) {
                            LOGGER.log(Level.FINEST, "HCI835D", "No roles for this user");
                        }
                        return authenticatedUser;
                    }
                }
                catch (InvalidNameException invalidNameException) {
                    LOGGER.log(Level.WARNING, "HCI837W", "RAC Exception: " + invalidNameException);
                }
                return null;
            }
            return null;
        }
        AuthenticatedUser authenticatedUser = this.getUser(dirContext, string, string2);
        if (authenticatedUser == null) {
            return null;
        }
        if (!this.checkCredentials(dirContext, authenticatedUser, string2)) {
            return null;
        }
        List<String> list = this.getRoles(dirContext, authenticatedUser);
        if (list != null && !list.isEmpty()) {
            if (this.debug) {
                String string5 = "";
                for (String string6 : list) {
                    string5 = string5 + " " + string6;
                }
                LOGGER.log(Level.FINEST, "HCI835D", "Found roles:" + string5);
            }
        } else if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "No roles for this user");
        }
        return authenticatedUser;
    }

    private AuthenticatedUser getUser(DirContext dirContext, String string, String string2) throws NamingException {
        return this.getUser(dirContext, string, string2, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticatedUser getUser(DirContext dirContext, String string, String string2, int n) throws NamingException {
        AuthenticatedUser authenticatedUser = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.userPassword != null) {
            arrayList.add(this.userPassword);
        }
        if (this.userRoleName != null) {
            arrayList.add(this.userRoleName);
        }
        if (this.userRoleAttribute != null) {
            arrayList.add(this.userRoleAttribute);
        }
        if (this.opidAttribute != null) {
            arrayList.add(this.opidAttribute);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        if (this.userPatternFormatArray != null && n >= 0) {
            authenticatedUser = this.getUserByPattern(dirContext, string, string2, stringArray, n);
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "Found user by pattern [" + authenticatedUser + "]");
            }
        } else {
            boolean bl = this.isUserSearchAsUser() && string2 != null;
            try {
                if (bl) {
                    this.userCredentialsAdd(dirContext, string, string2);
                }
                authenticatedUser = this.getUserBySearch(dirContext, string, stringArray);
            }
            finally {
                if (bl) {
                    this.userCredentialsRemove(dirContext);
                }
            }
            if (this.debug) {
                if (authenticatedUser == null) {
                    LOGGER.log(Level.FINEST, "HCI835D", "Could not find user by search [" + string + "], set rac.usersearch property if authorizing resources before authenticating users.");
                } else {
                    LOGGER.log(Level.FINEST, "HCI835D", "Found user by search [" + authenticatedUser + "]");
                }
            }
        }
        if (this.userPassword == null && string2 != null && authenticatedUser != null) {
            return new AuthenticatedUser(authenticatedUser.getUserName(), authenticatedUser.getDN(), string2, authenticatedUser.getRoles(), authenticatedUser.getUserRoleId(), authenticatedUser.getAttributes());
        }
        return authenticatedUser;
    }

    private AuthenticatedUser getUserByPattern(DirContext dirContext, String string, String[] stringArray, String string2) throws NamingException {
        Attributes attributes = null;
        try {
            attributes = stringArray == null || stringArray.length == 0 ? dirContext.getAttributes(string2) : dirContext.getAttributes(string2, stringArray);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return null;
        }
        if (attributes == null) {
            return null;
        }
        String string3 = null;
        if (this.userPassword != null) {
            string3 = this.getAttributeValue(this.userPassword, attributes);
        }
        String string4 = null;
        if (this.userRoleAttribute != null) {
            string4 = this.getAttributeValue(this.userRoleAttribute, attributes);
        }
        ArrayList<String> arrayList = null;
        if (this.userRoleName != null) {
            arrayList = this.addAttributeValues(this.userRoleName, attributes, arrayList);
        }
        return new AuthenticatedUser(string, string2, string3, arrayList, string4, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticatedUser getUserByPattern(DirContext dirContext, String string, String string2, String[] stringArray, int n) throws NamingException {
        AuthenticatedUser authenticatedUser = null;
        if (string == null || this.userPatternFormatArray[n] == null) {
            return null;
        }
        String string3 = this.userPatternFormatArray[n].format(new String[]{string});
        try {
            authenticatedUser = this.getUserByPattern(dirContext, string, stringArray, string3);
        }
        catch (NameNotFoundException nameNotFoundException) {
            return null;
        }
        catch (NamingException namingException) {
            try {
                this.userCredentialsAdd(dirContext, string3, string2);
                authenticatedUser = this.getUserByPattern(dirContext, string, stringArray, string3);
            }
            finally {
                this.userCredentialsRemove(dirContext);
            }
        }
        return authenticatedUser;
    }

    private AuthenticatedUser getUserBySearch(DirContext dirContext, String string, String[] stringArray) throws NamingException {
        Attributes attributes;
        NamingEnumeration<SearchResult> namingEnumeration;
        block22: {
            if (string == null || this.userSearchFormat == null) {
                return null;
            }
            String string2 = this.userSearchFormat.format(new String[]{string});
            SearchControls searchControls = new SearchControls();
            if (this.userSubtree) {
                searchControls.setSearchScope(2);
            } else {
                searchControls.setSearchScope(1);
            }
            searchControls.setCountLimit(this.sizeLimit);
            searchControls.setTimeLimit(this.timeLimit);
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            searchControls.setReturningAttributes(stringArray);
            namingEnumeration = null;
            try {
                namingEnumeration = dirContext.search(this.userBase, string2, searchControls);
            }
            catch (InvalidSearchFilterException invalidSearchFilterException) {
                if (this.debug) {
                    LOGGER.log(Level.FINEST, "HCI835D", "Exception:  rac.usersearch [" + this.userSearch + "] incorrectly specified");
                }
            }
            catch (InvalidSearchControlsException invalidSearchControlsException) {
                if (this.debug) {
                    LOGGER.log(Level.FINEST, "HCI835D", "Exception:  rac.sizelimit  [" + this.sizeLimit + "] or rac.timelimit [ " + this.timeLimit + "] not valid");
                }
            }
            catch (NamingException namingException) {
                if (!this.debug) break block22;
                LOGGER.log(Level.FINEST, "HCI835D", "Exception:  " + namingException);
            }
        }
        try {
            if (namingEnumeration == null || !namingEnumeration.hasMore()) {
                return null;
            }
        }
        catch (PartialResultException partialResultException) {
            return null;
        }
        SearchResult searchResult = namingEnumeration.next();
        try {
            if (namingEnumeration.hasMore()) {
                if (this.debug) {
                    LOGGER.log(Level.INFO, "HCI836I", "username " + string + " has multiple entries");
                }
                return null;
            }
        }
        catch (PartialResultException partialResultException) {
            // empty catch block
        }
        String string3 = this.getDistinguishedName(dirContext, this.userBase, searchResult);
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "  entry found for " + string + " with dn " + string3);
        }
        if ((attributes = searchResult.getAttributes()) == null) {
            return null;
        }
        String string4 = null;
        if (this.userPassword != null) {
            string4 = this.getAttributeValue(this.userPassword, attributes);
        }
        String string5 = null;
        if (this.userRoleAttribute != null) {
            string5 = this.getAttributeValue(this.userRoleAttribute, attributes);
        }
        ArrayList<String> arrayList = null;
        if (this.userRoleName != null) {
            arrayList = this.addAttributeValues(this.userRoleName, attributes, arrayList);
        }
        AuthenticatedUser authenticatedUser = new AuthenticatedUser(string, string3, string4, arrayList, string5, attributes);
        this.getRoles(dirContext, authenticatedUser);
        return authenticatedUser;
    }

    private boolean checkCredentials(DirContext dirContext, AuthenticatedUser authenticatedUser, String string) throws NamingException {
        boolean bl = false;
        bl = this.userPassword == null ? this.bindAsUser(dirContext, authenticatedUser, string) : this.compareCredentials(dirContext, authenticatedUser, string);
        if (this.debug) {
            if (bl) {
                LOGGER.log(Level.FINEST, "HCI835D", "RAC authenticateSuccess: " + authenticatedUser.getUserName());
            } else {
                LOGGER.log(Level.FINEST, "HCI835D", "RAC authenticateFailure: " + authenticatedUser.getUserName());
            }
        }
        return bl;
    }

    private boolean compareCredentials(DirContext dirContext, AuthenticatedUser authenticatedUser, String string) throws NamingException {
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "  validating credentials");
        }
        if (authenticatedUser == null || string == null) {
            return false;
        }
        String string2 = authenticatedUser.getPassword();
        return string.equals(string2);
    }

    private boolean bindAsUser(DirContext dirContext, AuthenticatedUser authenticatedUser, String string) throws NamingException {
        boolean bl;
        block6: {
            if (string == null || authenticatedUser == null) {
                return false;
            }
            String string2 = authenticatedUser.getDN();
            if (string2 == null) {
                return false;
            }
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "  validating credentials by binding as the user");
            }
            this.userCredentialsAdd(dirContext, string2, string);
            bl = false;
            try {
                if (this.debug) {
                    LOGGER.log(Level.FINEST, "HCI835D", "  binding as " + string2);
                }
                dirContext.getAttributes("", null);
                bl = true;
            }
            catch (AuthenticationException authenticationException) {
                if (!this.debug) break block6;
                LOGGER.log(Level.FINEST, "HCI835D", "  bind attempt failed");
            }
        }
        this.userCredentialsRemove(dirContext);
        return bl;
    }

    private void userCredentialsAdd(DirContext dirContext, String string, String string2) throws NamingException {
        dirContext.addToEnvironment("java.naming.security.principal", string);
        dirContext.addToEnvironment("java.naming.security.credentials", string2);
    }

    private void userCredentialsRemove(DirContext dirContext) throws NamingException {
        if (this.connectionName != null) {
            dirContext.addToEnvironment("java.naming.security.principal", this.connectionName);
        } else {
            dirContext.removeFromEnvironment("java.naming.security.principal");
        }
        if (this.connectionPassword != null) {
            dirContext.addToEnvironment("java.naming.security.credentials", this.connectionPassword);
        } else {
            dirContext.removeFromEnvironment("java.naming.security.credentials");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getRoles(DirContext dirContext, AuthenticatedUser authenticatedUser) throws NamingException {
        Object object;
        Object object2;
        NamingEnumeration<SearchResult> namingEnumeration;
        if (authenticatedUser == null) {
            return null;
        }
        String string = authenticatedUser.getDN();
        String string2 = authenticatedUser.getUserName();
        String string3 = authenticatedUser.getUserRoleId();
        if (string == null || string2 == null) {
            return null;
        }
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "  getRoles(" + string + ")");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = authenticatedUser.getRoles();
        if (list != null) {
            arrayList.addAll(list);
        }
        if (this.commonRole != null) {
            arrayList.add(this.commonRole);
        }
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "  Found " + arrayList.size() + " user internal roles");
            for (int i = 0; i < arrayList.size(); ++i) {
                LOGGER.log(Level.FINEST, "HCI835D", "  Found user internal role " + (String)arrayList.get(i));
            }
        }
        if (this.roleFormat == null || this.roleName == null) {
            return arrayList;
        }
        String string4 = this.roleFormat.format(new String[]{this.doRFC2254Encoding(string), string2, string3});
        SearchControls searchControls = new SearchControls();
        if (this.roleSubtree) {
            searchControls.setSearchScope(2);
        } else {
            searchControls.setSearchScope(1);
        }
        searchControls.setReturningAttributes(new String[]{this.roleName, this.opidAttribute});
        String string5 = null;
        if (this.roleBaseFormat != null) {
            namingEnumeration = dirContext.getNameParser("");
            Name name = namingEnumeration.parse(string);
            object2 = new String[name.size()];
            for (int i = 0; i < name.size(); ++i) {
                object2[i] = name.get(i);
            }
            string5 = this.roleBaseFormat.format(object2);
        } else {
            string5 = "";
        }
        namingEnumeration = null;
        boolean bl = this.isRoleSearchAsUser();
        try {
            if (bl) {
                this.userCredentialsAdd(dirContext, string, authenticatedUser.getPassword());
            }
            namingEnumeration = dirContext.search(string5, string4, searchControls);
        }
        finally {
            if (bl) {
                this.userCredentialsRemove(dirContext);
            }
        }
        if (namingEnumeration == null) {
            return arrayList;
        }
        object2 = new HashMap();
        while (namingEnumeration.hasMore()) {
            SearchResult searchResult = (SearchResult)namingEnumeration.next();
            object = searchResult.getAttributes();
            if (object == null) continue;
            authenticatedUser.mergeAttributes((Attributes)object);
            Object object3 = this.getDistinguishedName(dirContext, this.roleBase, searchResult);
            String object4 = this.getAttributeValue(this.roleName, (Attributes)object);
            if (object4 == null || object3 == null) continue;
            ((HashMap)object2).put(object3, object4);
        }
        if (this.debug) {
            Set set = ((HashMap)object2).keySet();
            LOGGER.log(Level.FINEST, "HCI835D", "  Found " + set.size() + " direct roles");
            for (Object object3 : set) {
                LOGGER.log(Level.FINEST, "HCI835D", "  Found direct role " + (String)object3 + " -- " + (String)((HashMap)object2).get(object3));
            }
        }
        if (this.isRoleNested()) {
            Object object5 = new HashMap(object2);
            while (!object5.isEmpty()) {
                object = new HashMap();
                for (Map.Entry entry : object5.entrySet()) {
                    string4 = this.roleFormat.format(new String[]{(String)entry.getKey(), (String)entry.getValue(), (String)entry.getValue()});
                    if (this.debug) {
                        LOGGER.log(Level.FINEST, "HCI835D", "Perform a nested group search with base " + this.roleBase + " and filter " + string4);
                    }
                    namingEnumeration = dirContext.search(this.roleBase, string4, searchControls);
                    while (namingEnumeration.hasMore()) {
                        SearchResult searchResult = namingEnumeration.next();
                        Attributes attributes = searchResult.getAttributes();
                        if (attributes == null) continue;
                        authenticatedUser.mergeAttributes(attributes);
                        String string6 = this.getDistinguishedName(dirContext, this.roleBase, searchResult);
                        String string7 = this.getAttributeValue(this.roleName, attributes);
                        if (string7 == null || string6 == null || ((HashMap)object2).keySet().contains(string6)) continue;
                        ((HashMap)object2).put(string6, string7);
                        object.put(string6, string7);
                        if (!this.debug) continue;
                        LOGGER.log(Level.FINEST, "HCI835D", "  Found nested role " + string6 + " -- " + string7);
                    }
                }
                object5 = object;
            }
        }
        arrayList.addAll(((HashMap)object2).values());
        authenticatedUser.mergeRoles(arrayList);
        return authenticatedUser.getRoles();
    }

    private String getAttributeValue(String string, Attributes attributes) throws NamingException {
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "      retrieving attribute " + string);
        }
        if (string == null || attributes == null) {
            return null;
        }
        Attribute attribute = attributes.get(string);
        if (attribute == null) {
            return null;
        }
        Object object = attribute.get();
        if (object == null) {
            return null;
        }
        String string2 = null;
        string2 = object instanceof byte[] ? new String((byte[])object) : object.toString();
        return string2;
    }

    private String[] getAttributeValues(String string, Attributes attributes) throws NamingException {
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "      retrieving attribute " + string);
        }
        if (string == null || attributes == null) {
            return null;
        }
        Attribute attribute = attributes.get(string);
        if (attribute != null && attribute.size() > 0) {
            String[] stringArray = new String[attribute.size()];
            for (int i = 0; i < attribute.size(); ++i) {
                Object object = attribute.get(i);
                if (object == null) {
                    throw new NamingException("resource directory entry has null value:" + attributes.toString());
                }
                String string2 = null;
                string2 = object instanceof byte[] ? new String((byte[])object) : object.toString();
                stringArray[i] = string2;
            }
            return stringArray;
        }
        return null;
    }

    private ArrayList<String> addAttributeValues(String string, Attributes attributes, ArrayList<String> arrayList) throws NamingException {
        Attribute attribute;
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "  retrieving values for attribute " + string);
        }
        if (string == null || attributes == null) {
            return arrayList;
        }
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if ((attribute = attributes.get(string)) == null) {
            return arrayList;
        }
        NamingEnumeration<?> namingEnumeration = attribute.getAll();
        while (namingEnumeration.hasMore()) {
            String string2 = (String)namingEnumeration.next();
            arrayList.add(string2);
        }
        return arrayList;
    }

    private void close(DirContext dirContext) {
        if (dirContext == null) {
            return;
        }
        try {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "Closing directory context");
            }
            dirContext.close();
        }
        catch (NamingException namingException) {
            LOGGER.log(Level.SEVERE, "HCI838E", "RAC close:" + namingException);
        }
        this.context = null;
    }

    private DirContext open() throws NamingException {
        if (this.context != null) {
            return this.context;
        }
        try {
            this.context = this.createDirContext(this.getDirectoryContextEnvironment());
        }
        catch (Exception exception) {
            this.connectionAttempt = 1;
            LOGGER.log(Level.SEVERE, "HCI838E", "RAC Exception: Can't connect to configured LDAP server: " + exception);
            this.context = this.createDirContext(this.getDirectoryContextEnvironment());
        }
        finally {
            this.connectionAttempt = 0;
        }
        return this.context;
    }

    private DirContext createDirContext(Hashtable<String, String> hashtable) throws NamingException {
        return new InitialDirContext(hashtable);
    }

    private Hashtable<String, String> getDirectoryContextEnvironment() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.debug) {
            if (this.connectionAttempt == 0 && this.connectionURL != null) {
                LOGGER.log(Level.FINEST, "HCI835D", "Connecting to URL " + this.connectionURL);
            } else if (this.connectionAttempt > 0 && this.alternateURL != null) {
                LOGGER.log(Level.FINEST, "HCI835D", "Connecting to URL " + this.alternateURL);
            } else if (this.connectionAttempt == 1 && this.connectionURL != null) {
                LOGGER.log(Level.FINEST, "HCI835D", "Failed to connect to " + this.connectionURL);
            } else if (this.connectionAttempt == 2 && this.alternateURL != null) {
                LOGGER.log(Level.FINEST, "HCI835D", "Failed to connect to " + this.alternateURL);
            } else {
                LOGGER.log(Level.FINEST, "HCI835D", "Neither connectionurl nor alternateurl has been configured ");
            }
        }
        hashtable.put("java.naming.factory.initial", this.contextFactory);
        if (this.connectionName != null) {
            hashtable.put("java.naming.security.principal", this.connectionName);
        }
        if (this.connectionPassword != null) {
            hashtable.put("java.naming.security.credentials", this.connectionPassword);
        }
        if (this.connectionURL != null && this.connectionAttempt == 0) {
            hashtable.put("java.naming.provider.url", this.connectionURL);
        } else if (this.alternateURL != null && this.connectionAttempt > 0) {
            hashtable.put("java.naming.provider.url", this.alternateURL);
        }
        if (this.authentication != null) {
            hashtable.put("java.naming.security.authentication", this.authentication);
        }
        if (this.protocol != null) {
            hashtable.put("java.naming.security.protocol", this.protocol);
        }
        if (this.connectionTimeout != null) {
            hashtable.put("com.sun.jndi.ldap.connect.timeout", this.connectionTimeout);
        }
        return hashtable;
    }

    private void release(DirContext dirContext) {
    }

    private String[] parseUserPatternString(String string) {
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = string.indexOf(40);
            if (n == -1) {
                return new String[]{string};
            }
            int n2 = 0;
            while (n > -1) {
                int n3 = 0;
                while (string.charAt(n + 1) == '|' || n != 0 && string.charAt(n - 1) == '\\') {
                    n = string.indexOf("(", n + 1);
                }
                n3 = string.indexOf(")", n + 1);
                while (string.charAt(n3 - 1) == '\\') {
                    n3 = string.indexOf(")", n3 + 1);
                }
                String string2 = string.substring(n + 1, n3);
                arrayList.add(string2);
                n2 = n3 + 1;
                n = string.indexOf(40, n2);
            }
            return arrayList.toArray(new String[0]);
        }
        return null;
    }

    private String doRFC2254Encoding(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuilder.append("\\5c");
                    continue block7;
                }
                case '*': {
                    stringBuilder.append("\\2a");
                    continue block7;
                }
                case '(': {
                    stringBuilder.append("\\28");
                    continue block7;
                }
                case ')': {
                    stringBuilder.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    stringBuilder.append("\\00");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    private String getDistinguishedName(DirContext dirContext, String string, SearchResult searchResult) throws NamingException {
        if (searchResult.isRelative()) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "  search returned relative name: " + searchResult.getName());
            }
            NameParser nameParser = dirContext.getNameParser("");
            Name name = nameParser.parse(dirContext.getNameInNamespace());
            Name name2 = nameParser.parse(string);
            Name name3 = nameParser.parse(new CompositeName(searchResult.getName()).get(0));
            Name name4 = name.addAll(name2);
            name4 = name4.addAll(name3);
            return name4.toString();
        }
        String string2 = searchResult.getName();
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "  search returned absolute name: " + searchResult.getName());
        }
        try {
            NameParser nameParser = dirContext.getNameParser("");
            URI uRI = new URI(string2);
            String string3 = uRI.getPath();
            if (string3.length() < 1) {
                throw new InvalidNameException("Search returned unparseable absolute name: " + string2);
            }
            Name name = nameParser.parse(string3.substring(1));
            return name.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidNameException("Search returned unparseable absolute name: " + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rememberResource(String string, int n, AuthorizedResource authorizedResource) {
        HashMap<String, AuthorizedResource> hashMap;
        String string2 = string.toUpperCase() + ":" + n;
        if (!(this.cacheSize <= 0 || cachedResources.size() < this.cacheSize || authorizedResource != null && authorizedResource.permanent)) {
            hashMap = cachedResources;
            synchronized (hashMap) {
                long l = 2000000000L;
                String string3 = null;
                Iterator<Map.Entry<String, AuthorizedResource>> iterator = cachedResources.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, AuthorizedResource> entry = iterator.next();
                    AuthorizedResource authorizedResource2 = entry.getValue();
                    if (authorizedResource2 == null) {
                        iterator.remove();
                        continue;
                    }
                    if (authorizedResource2.getLastUsed() >= l) continue;
                    l = authorizedResource2.getLastUsed();
                    string3 = entry.getKey();
                }
                if (string3 != null) {
                    cachedResources.remove(string3);
                }
            }
        }
        hashMap = cachedResources;
        synchronized (hashMap) {
            if (authorizedResource != null) {
                authorizedResource.hasBeenUsed();
            }
            cachedResources.put(string2, authorizedResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizedResource recallResource(String string, int n) {
        String string2 = string.toUpperCase() + ":" + n;
        AuthorizedResource authorizedResource = null;
        HashMap<String, AuthorizedResource> hashMap = cachedResources;
        synchronized (hashMap) {
            if (cachedResources.containsKey(string2)) {
                authorizedResource = cachedResources.get(string2);
                if (authorizedResource != null) {
                    if (authorizedResource.isExpired(this.cacheTime)) {
                        cachedResources.remove(string);
                        authorizedResource = null;
                    } else {
                        authorizedResource.hasBeenUsed();
                    }
                } else {
                    if (RACLookup.isExpired(this.cacheTime, GlobalResourceExpiredDate)) {
                        Iterator<Map.Entry<String, AuthorizedResource>> iterator = cachedResources.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry<String, AuthorizedResource> entry = iterator.next();
                            if (entry.getValue() != null) continue;
                            iterator.remove();
                        }
                        GlobalResourceExpiredDate = new Date();
                    }
                    authorizedResource = NotFoundResource;
                }
            }
        }
        return authorizedResource;
    }

    private AuthorizedResource authorize(DirContext dirContext, AuthenticatedUser authenticatedUser, int n, String string, String string2) throws NamingException {
        if (authenticatedUser == null) {
            return null;
        }
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "  authorize(" + string2 + " of " + this.resourceTypes[n] + " " + string + " for " + authenticatedUser.getUserName() + ")");
        }
        if (cachedResources.isEmpty()) {
            this.cacheResourceGroups(dirContext);
        }
        String string3 = string;
        while (true) {
            int n2;
            AuthorizedResource authorizedResource;
            if ((authorizedResource = this.recallResource(string3, n)) == NotFoundResource) {
                authorizedResource = null;
            } else if (authorizedResource == null) {
                authorizedResource = this.getResource(dirContext, authenticatedUser, n, string3);
                this.rememberResource(string3, n, authorizedResource);
            }
            if (authorizedResource != null) {
                n2 = this.isAccessAllowed(authenticatedUser.getUserName(), authenticatedUser.getRoles(), string2, authorizedResource);
                if (n2 < 0) {
                    return null;
                }
                if (n2 > 0) {
                    return authorizedResource;
                }
            }
            if (string3.endsWith(".*")) {
                string3 = string3.substring(0, string3.length() - 3);
            }
            if ((n2 = string3.lastIndexOf(46)) > 0) {
                string3 = string3.substring(0, n2) + ".*";
                continue;
            }
            if (string3.equals("*")) {
                return null;
            }
            string3 = "*";
        }
    }

    public String attribute(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        AuthenticatedUser authenticatedUser = this.recallUser(string, false);
        if (authenticatedUser == null) {
            return null;
        }
        String string3 = authenticatedUser.getAttributeValue(string2);
        return string3;
    }

    private boolean match(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string2.contains(string)) {
            return true;
        }
        return string.equals("execute") ? string2.contains("execute") || string2.contains("all") : (string.equals("read") ? string2.contains("update") || string2.contains("alter") || string2.contains("all") : (string.equals("update") ? string2.contains("alter") || string2.contains("all") : (string.equals("alter") ? string2.contains("all") : (string.equals("submit") ? string2.contains("all") : (string.equals("cancel") ? string2.contains("submit") || string2.contains("all") : (string.equals("restart") ? string2.contains("checkpoint") || string2.contains("all") : (string.equals("checkpoint") || string.equals("restart") ? string2.contains("all") : (string.equals("view") ? string2.contains("all") : string.equals("purge") && string2.contains("all")))))))));
    }

    private int isAccessAllowed(String string, List<String> list, String string2, AuthorizedResource authorizedResource) {
        if (list != null) {
            for (String string3 : list) {
                if (this.match(string2, authorizedResource.getDenyAccessTo(string3))) {
                    if (this.debug) {
                        LOGGER.log(Level.FINEST, "HCI835D", "    Deny " + string2 + " by " + string + " to " + this.resourceTypes[authorizedResource.getResourceType()] + " " + authorizedResource.getResourceName() + " because of rights given to group " + string3);
                    }
                    return -1;
                }
                if (!this.match(string2, authorizedResource.getAllowAccessTo(string3))) continue;
                if (this.debug) {
                    LOGGER.log(Level.FINEST, "HCI835D", "    Allow " + string2 + " by " + string + " to " + this.resourceTypes[authorizedResource.getResourceType()] + " " + authorizedResource.getResourceName() + " because of rights given to group " + string3);
                }
                return 1;
            }
        }
        if (this.match(string2, authorizedResource.getDenyDefault())) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "    Deny " + string2 + " by " + string + " to " + this.resourceTypes[authorizedResource.getResourceType()] + " " + authorizedResource.getResourceName() + " because default rights on this resource");
            }
            return -1;
        }
        if (this.match(string2, authorizedResource.getAllowDefault())) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "    Allow " + string2 + " by " + string + " to " + this.resourceTypes[authorizedResource.getResourceType()] + " " + authorizedResource.getResourceName() + " because of default rights on this resource");
            }
            return 1;
        }
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "    No rule for " + string2 + " by " + string + " to " + this.resourceTypes[authorizedResource.getResourceType()] + " " + authorizedResource.getResourceName());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private AuthorizedResource getResource(DirContext dirContext, AuthenticatedUser authenticatedUser, int n, String string) throws NamingException {
        Object object;
        int n2;
        Cloneable cloneable;
        String[] stringArray;
        if (this.resourceBaseFormat == null || this.resourceBase == null || this.resourceMemberAttribute == null || this.resourceRuleAttribute == null) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "    authenticate cannot continue without configurations forrac.resourcebase, rac.resourcememberattribute and rac.resourceruleattribute");
            }
            return null;
        }
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "    getResource(" + string + ")");
        }
        String string2 = null;
        if (authenticatedUser != null) {
            string2 = authenticatedUser.getDN();
        }
        String string3 = null;
        String[] stringArray2 = null;
        if (string2 != null) {
            stringArray = dirContext.getNameParser("");
            cloneable = stringArray.parse(string2);
            stringArray2 = new String[cloneable.size() + 2];
            for (n2 = 0; n2 < cloneable.size(); ++n2) {
                stringArray2[n2 + 2] = cloneable.get(n2);
            }
        } else {
            stringArray2 = new String[]{string, this.resourceTypes[n]};
        }
        string3 = this.resourceBaseFormat.format(stringArray2);
        stringArray = null;
        if (this.resourceMemberAttribute != null && this.resourceRuleAttribute != null) {
            stringArray = new String[]{this.resourceMemberAttribute, this.resourceRuleAttribute};
        } else if (this.resourceMemberAttribute != null) {
            stringArray = new String[]{this.resourceMemberAttribute};
        }
        cloneable = null;
        n2 = this.isResourceSearchAsUser() ? 1 : 0;
        try {
            if (n2 != 0) {
                this.userCredentialsAdd(dirContext, string2, authenticatedUser.getPassword());
            }
            cloneable = dirContext.getAttributes(string3, stringArray);
        }
        catch (NamingException namingException) {
            if (namingException instanceof CommunicationException || namingException instanceof ServiceUnavailableException) {
                throw namingException;
            }
        }
        finally {
            if (n2 != 0) {
                this.userCredentialsRemove(dirContext);
            }
        }
        if (cloneable == null || cloneable.size() == 0) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "      no rule for this resource");
            }
            return null;
        }
        String string4 = null;
        String string5 = null;
        String[] stringArray3 = this.getAttributeValues(this.resourceRuleAttribute, (Attributes)cloneable);
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                object = stringArray3[i].toLowerCase();
                if (((String)object).startsWith("allow:")) {
                    if (string4 == null) {
                        string4 = ((String)object).substring(6);
                        continue;
                    }
                    string4 = string4 + "," + ((String)object).substring(6);
                    continue;
                }
                if (!((String)object).startsWith("deny:")) continue;
                string5 = string5 == null ? ((String)object).substring(5) : string5 + "," + ((String)object).substring(5);
            }
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object = new HashMap();
        stringArray3 = this.getAttributeValues(this.resourceMemberAttribute, (Attributes)cloneable);
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                void var19_26;
                String string6 = null;
                String string7 = null;
                if (this.roleName != null && !this.roleName.isEmpty()) {
                    for (String string8 : stringArray3[i].split(",")) {
                        String[] stringArray4 = string8.split("=");
                        if (stringArray4.length != 2) continue;
                        if (stringArray4[0].equalsIgnoreCase(this.roleName)) {
                            string7 = stringArray4[1];
                            if (string6 == null) continue;
                        } else {
                            if (!stringArray4[0].equalsIgnoreCase(this.resourceRuleAttribute)) continue;
                            string6 = stringArray4[1];
                            if (string7 == null) {
                                continue;
                            }
                        }
                        break;
                    }
                } else if (this.roleBase == null || !this.roleBase.isEmpty()) {
                    // empty if block
                }
                if (string7 == null || string6 == null) continue;
                String string9 = "";
                String string10 = "";
                for (String string11 : string6.split("/")) {
                    String[] stringArray5 = string11.split(":");
                    if (stringArray5.length != 2) continue;
                    if (stringArray5[0].equalsIgnoreCase("allow")) {
                        void var19_28;
                        if (!var19_26.isEmpty()) {
                            String string12 = (String)var19_26 + ",";
                        }
                        String string13 = (String)var19_28 + stringArray5[1];
                        continue;
                    }
                    if (!stringArray5[0].equalsIgnoreCase("deny")) continue;
                    if (!string10.isEmpty()) {
                        string10 = string10 + ",";
                    }
                    string10 = string10 + stringArray5[1];
                }
                if (!var19_26.isEmpty()) {
                    void var19_31;
                    if (hashMap.get(string7) != null) {
                        String string14 = (String)hashMap.get(string7) + "," + (String)var19_26;
                    }
                    hashMap.put(string7, var19_31.toLowerCase());
                }
                if (string10.isEmpty()) continue;
                if (object.get(string7) != null) {
                    string10 = (String)object.get(string7) + "," + string10;
                }
                object.put(string7, string10.toLowerCase());
            }
        }
        if (this.debug) {
            for (String string6 : hashMap.keySet()) {
                LOGGER.log(Level.FINEST, "HCI835D", "        group allow rule: " + string6 + " with right " + (String)hashMap.get(string6));
            }
            for (String string6 : object.keySet()) {
                LOGGER.log(Level.FINEST, "HCI835D", "        group deny rule:" + string6 + " to right " + (String)object.get(string6));
            }
            if (string4 != null) {
                LOGGER.log(Level.FINEST, "HCI835D", "        default allow rule: " + string4);
            }
            if (string5 != null) {
                LOGGER.log(Level.FINEST, "HCI835D", "        default deny rule: " + string5);
            }
        }
        return new AuthorizedResource(n, string, string2, string4, string5, hashMap.isEmpty() ? null : hashMap, (Map<String, String>)(object.isEmpty() ? null : object));
    }

    private void cacheResourceGroups(DirContext dirContext) throws NamingException {
        if (this.debug) {
            LOGGER.log(Level.FINEST, "HCI835D", "Cache all Resource Groups");
        }
        if (this.resourceGroupBaseFormat == null || this.resourceGroupBase == null || this.resourceGroupName == null || this.resourceGroupMemberAttribute == null || this.resourceGroupRuleAttribute == null) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "      resource groups missing some configuration settings -- ignoring resource groups");
            }
            return;
        }
        String string3 = "(objectClass=*)";
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(1);
        searchControls.setReturningAttributes(new String[]{this.resourceGroupName, this.resourceGroupRuleAttribute});
        NamingEnumeration<SearchResult> namingEnumeration = null;
        try {
            namingEnumeration = dirContext.search(this.resourceGroupBase, string3, searchControls);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (namingEnumeration == null || !namingEnumeration.hasMoreElements()) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "      no resource groups defined");
            }
            return;
        }
        try {
            while (namingEnumeration.hasMore()) {
                SearchResult searchResult = namingEnumeration.next();
                Attributes attributes = searchResult.getAttributes();
                if (attributes == null) continue;
                String string4 = this.getAttributeValue(this.resourceGroupName, attributes);
                String string5 = this.getAttributeValue(this.resourceGroupRuleAttribute, attributes);
                String string6 = null;
                String string7 = null;
                if (string5 != null && string5.startsWith("allow:")) {
                    string6 = string5.substring(6);
                } else if (string5 != null && string5.startsWith("deny:")) {
                    string7 = string5.substring(5);
                }
                List<String> list = this.getGroupMembers(string4, dirContext);
                if (this.debug) {
                    LOGGER.log(Level.FINEST, "HCI835D", "      Resource Group '" + string4 + "' default access rule '" + (string5 == null ? "<no default access rule>" : string5) + "' has members:");
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                list.stream().filter(string -> IntStream.range(0, this.resourceTypes.length).noneMatch(n -> string.contains(this.resourceTypes[n]))).forEach(string -> {
                    Map<String, String> map3 = this.parseGroupMemberDN((String)string, this.resourceName, this.resourceGroupRuleAttribute);
                    String string2 = map3.get(this.resourceName.toLowerCase());
                    String string3 = map3.get(this.resourceGroupRuleAttribute.toLowerCase());
                    if (string2 != null && string3 != null) {
                        if (string3.startsWith("allow:")) {
                            hashMap.put(string2, string3.substring(6));
                        } else if (string3.startsWith("deny:")) {
                            hashMap2.put(string2, string3.substring(5));
                        }
                        if (this.debug) {
                            LOGGER.log(Level.FINEST, "HCI835D", "          group:    '" + string2 + "' has right '" + string3 + "'");
                        }
                    }
                });
                for (String string8 : list) {
                    if (!Arrays.stream(this.resourceTypes).anyMatch(string2 -> string8.contains((CharSequence)string2))) continue;
                    if (this.debug) {
                        LOGGER.log(Level.FINEST, "HCI835D", "          resource: '" + string8 + "'");
                    }
                    int n2 = IntStream.range(0, this.resourceTypes.length).filter(n -> string8.contains(this.resourceTypes[n])).findFirst().getAsInt();
                    Map<String, String> map = this.parseGroupMemberDN(string8, this.resourceName);
                    String string9 = map.get(this.resourceName.toLowerCase());
                    if (string9 == null) continue;
                    AuthorizedResource authorizedResource = new AuthorizedResource(n2, string9, string8, string6, string7, hashMap, hashMap2);
                    authorizedResource = authorizedResource.mergeResource(this.recallResource(string9, n2));
                    try {
                        authorizedResource = authorizedResource.mergeResource(this.getResource(dirContext, null, n2, string8));
                    }
                    catch (NamingException namingException) {
                        if (this.debug) {
                            LOGGER.log(Level.FINEST, "HCI835D", "      partial results: " + namingException);
                        }
                        return;
                    }
                    authorizedResource.setPermanent();
                    this.rememberResource(string9, n2, authorizedResource);
                    if (!this.debug) continue;
                    LOGGER.log(Level.FINEST, "HCI835D", "        Resulting ACL: '" + authorizedResource.toString());
                }
            }
        }
        catch (PartialResultException partialResultException) {
            if (this.debug) {
                LOGGER.log(Level.FINEST, "HCI835D", "      partial results: " + partialResultException);
            }
            return;
        }
    }

    private Map<String, String> parseGroupMemberDN(String string3, String ... stringArray3) {
        Map<String, String> map = Stream.of(string3).flatMap(commaSplitPtr::splitAsStream).map(equalSignSplitPtr::split).filter(stringArray2 -> ((String[])stringArray2).length == 2 && Arrays.stream(stringArray3).anyMatch(string -> string.equalsIgnoreCase(stringArray2[0]))).collect(Collectors.toMap(stringArray -> stringArray[0].toLowerCase(), stringArray -> stringArray[1], (string, string2) -> String.format("%s,%s", string, string2)));
        return map;
    }

    private List<String> getGroupMembers(String string, DirContext dirContext) {
        NamingEnumeration<SearchResult> namingEnumeration = null;
        NamingEnumeration<?> namingEnumeration2 = null;
        SearchControls searchControls = null;
        SearchResult searchResult = null;
        Attribute attribute = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = String.format("(%s=%s)", this.resourceGroupName, string);
        try {
            String string3 = this.resourceGroupMemberAttribute;
            searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{string3});
            namingEnumeration = dirContext.search(this.resourceGroupBase, string2, searchControls);
            if (namingEnumeration.hasMoreElements() && (attribute = (searchResult = namingEnumeration.next()).getAttributes().get(string3)) != null && attribute.size() > 0) {
                namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMore()) {
                    arrayList.add((String)namingEnumeration2.next());
                }
                return arrayList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = 0;
        boolean bl = true;
        while (bl) {
            String string4 = this.generateRangeString(n, false);
            searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(new String[]{string4});
            try {
                namingEnumeration = dirContext.search(this.resourceGroupBase, string2, searchControls);
                if (!namingEnumeration.hasMoreElements()) continue;
                searchResult = namingEnumeration.next();
                attribute = searchResult.getAttributes().get(string4);
                namingEnumeration2 = attribute == null ? searchResult.getAttributes().get(this.generateRangeString(n, true)).getAll() : attribute.getAll();
                while (namingEnumeration2.hasMore()) {
                    arrayList.add((String)namingEnumeration2.next());
                }
                ++n;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return arrayList;
    }

    private String generateRangeString(int n, boolean bl) {
        return String.format("%s;range=%s-%s", this.resourceGroupMemberAttribute, n * 1000, bl ? "*" : Integer.valueOf((n + 1) * 1000 - 1));
    }

    public static boolean isExpired(int n, Date date) {
        if (n <= 0) {
            return true;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, n);
        return calendar.getTime().before(new Date());
    }

    protected static class AuthorizedResource {
        public static long LastUsed = 1L;
        private final int resourcetype;
        private final String resourcename;
        private final String dn;
        private final String allowDefault;
        private final String denyDefault;
        private final Map<String, String> allowAccessToGroup;
        private final Map<String, String> denyAccessToGroup;
        private final Date checkedDate;
        private boolean permanent;
        private long lru;

        public AuthorizedResource(int n, String string, String string2, String string3, String string4, Map<String, String> map, Map<String, String> map2) {
            this.resourcetype = n;
            this.resourcename = string;
            this.dn = string2;
            this.allowDefault = string3;
            this.denyDefault = string4;
            this.allowAccessToGroup = map;
            this.denyAccessToGroup = map2;
            this.checkedDate = new Date();
            this.permanent = false;
            this.lru = 0L;
        }

        public String toString() {
            String string = "Authorized resource '" + this.resourcename + "'" + (this.allowDefault == null ? "" : ", allow default='" + this.allowDefault + "'") + (this.denyDefault == null ? "" : ", deny default='" + this.denyDefault + "'");
            if (this.allowAccessToGroup != null && this.allowAccessToGroup.size() > 0) {
                string = string + "; allow access to groups ";
                for (String string2 : this.allowAccessToGroup.keySet()) {
                    string = string + " " + string2 + "='" + this.allowAccessToGroup.get(string2) + "'";
                }
            }
            if (this.denyAccessToGroup != null && this.denyAccessToGroup.size() > 0) {
                string = string + "; deny access to groups ";
                for (String string2 : this.denyAccessToGroup.keySet()) {
                    string = string + " " + string2 + "='" + this.denyAccessToGroup.get(string2) + "'";
                }
            }
            return string;
        }

        public int getResourceType() {
            return this.resourcetype;
        }

        public String getResourceName() {
            return this.resourcename;
        }

        public String getDN() {
            return this.dn;
        }

        public String getAllowAccessTo(String string) {
            if (this.allowAccessToGroup == null) {
                return null;
            }
            return this.allowAccessToGroup.get(string);
        }

        public String getDenyAccessTo(String string) {
            if (this.denyAccessToGroup == null) {
                return null;
            }
            return this.denyAccessToGroup.get(string);
        }

        public String getDenyDefault() {
            return this.denyDefault;
        }

        public String getAllowDefault() {
            return this.allowDefault;
        }

        public Date getCheckedDate() {
            return this.checkedDate;
        }

        public long getLastUsed() {
            return this.lru;
        }

        public void hasBeenUsed() {
            this.lru = LastUsed++;
        }

        public void setPermanent() {
            this.permanent = true;
        }

        public boolean isExpired(int n) {
            if (this.permanent) {
                return false;
            }
            return RACLookup.isExpired(n, this.checkedDate);
        }

        private AuthorizedResource mergeResource(AuthorizedResource authorizedResource) {
            if (authorizedResource == null) {
                return this;
            }
            if (!this.dn.equalsIgnoreCase(authorizedResource.getDN())) {
                LOGGER.log(Level.SEVERE, "HCI838E", "Cannot merge '" + this.getDN() + "' with '" + authorizedResource.getDN() + "'");
            }
            if (authorizedResource.getAllowDefault() != null && this.allowDefault != null && !authorizedResource.getAllowDefault().equalsIgnoreCase(this.allowDefault)) {
                LOGGER.log(Level.WARNING, "HCI837W", "Conflicting default allow access rights on resource '" + this.getDN() + "' contained in two or more resource groups, '" + this.allowDefault + "' will be used");
            }
            if (authorizedResource.getDenyDefault() != null && this.denyDefault != null && !authorizedResource.getDenyDefault().equalsIgnoreCase(this.denyDefault)) {
                LOGGER.log(Level.WARNING, "HCI837W", "Conflicting default deny access rights on resource '" + this.getDN() + "' contained in two or more resource groups, '" + this.denyDefault + "' will be used");
            }
            String string = this.allowDefault;
            String string2 = this.denyDefault;
            Map<String, String> map = this.allowAccessToGroup;
            Map<String, String> map2 = this.denyAccessToGroup;
            if (string == null) {
                string = authorizedResource.getAllowDefault();
            }
            if (string2 == null) {
                string2 = authorizedResource.getDenyDefault();
            }
            if (string2 != null && string != null) {
                LOGGER.log(Level.WARNING, "HCI837W", "Merged access rules result in both an allow default '" + string + "' and a deny default rule '" + string2 + "', allow default will take precedence");
            }
            if (map == null) {
                map = authorizedResource.allowAccessToGroup;
            } else if (authorizedResource.allowAccessToGroup != null) {
                map.putAll(authorizedResource.allowAccessToGroup);
            }
            if (map2 == null) {
                map2 = authorizedResource.denyAccessToGroup;
            } else if (authorizedResource.allowAccessToGroup != null) {
                map2.putAll(authorizedResource.denyAccessToGroup);
            }
            return new AuthorizedResource(this.resourcetype, this.resourcename, this.dn, string, string2, map, map2);
        }
    }

    protected static class AuthenticatedUser {
        public static long LastUsed = 1L;
        private final String username;
        private final String dn;
        private final String password;
        private final List<String> roles;
        private final String userRoleId;
        private final Date checkedDate;
        private Attributes attrs;
        private long lru;

        public AuthenticatedUser(String string, String string2, String string3, List<String> list, String string4, Attributes attributes) {
            this.username = string;
            this.dn = string2;
            this.password = string3;
            this.roles = new ArrayList<String>();
            if (list != null) {
                this.roles.addAll(list);
            }
            this.userRoleId = string4;
            this.checkedDate = new Date();
            this.attrs = attributes;
            this.lru = 0L;
        }

        public Attributes getAttributes() {
            return this.attrs;
        }

        public void mergeAttributes(Attributes attributes) {
            if (attributes == null) {
                return;
            }
            if (this.attrs == null) {
                this.attrs = attributes;
            } else {
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                try {
                    while (namingEnumeration.hasMore()) {
                        Attribute attribute = namingEnumeration.next();
                        if (this.attrs.get(attribute.getID()) != null) continue;
                        this.attrs.put(attribute);
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }

        public void mergeRoles(List<String> list) {
            if (list != null) {
                for (String string : list) {
                    if (this.roles.contains(string)) continue;
                    this.roles.add(string);
                }
            }
        }

        public String toString() {
            String string = this.dn == null ? "Non-Authenticated user '" + this.username : "Authenticated user '" + this.username + "' in groups ";
            for (String string2 : this.roles) {
                string = string + "'" + string2 + "' ";
            }
            return string;
        }

        public String getUserName() {
            return this.username;
        }

        public boolean isAuthenticated() {
            return this.dn != null;
        }

        public String getDN() {
            return this.dn;
        }

        public String getPassword() {
            return this.password;
        }

        public List<String> getRoles() {
            return this.roles;
        }

        public String getUserRoleId() {
            return this.userRoleId;
        }

        public Date getCheckedDate() {
            return this.checkedDate;
        }

        public long getLastUsed() {
            return this.lru;
        }

        public void hasBeenUsed() {
            this.lru = LastUsed++;
        }

        public boolean isExpired(int n) {
            return RACLookup.isExpired(n, this.checkedDate);
        }

        public String getAttributeValue(String string) {
            if (this.attrs == null) {
                return null;
            }
            Attribute attribute = this.attrs.get(string);
            if (attribute == null) {
                return null;
            }
            try {
                Object object = attribute.get();
                if (object == null) {
                    return null;
                }
                return object.toString();
            }
            catch (NamingException namingException) {
                return null;
            }
        }
    }
}

