/*
 * Decompiled with CFR 0.152.
 */
import com.heirloomcomputing.ecc.Services;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class heirloomcli {
    static String Usage = "Usage: \n\n     java -jar hcli.jar [options] [args] \n\n     1)List Applications:\n       java -jar hcli.jar -list --type apps    \n                                  --user <userName>    \n                                  --password <password> \n\n     2)List Products:\n       java -jar hcli.jar -list --type platforms    \n                                  --user <userName>   \n                                  --password <password> \n\n     3)Create Application:\n       java -jar hcli.jar -create --productid \n                                    --name <App Name>\n                                    --user <userName>    \n                                    --password <password> \n        Where productid is the product ID number obtained using option[3]\n\n     4)Start Application:\n       java -jar hcli.jar -start  --name <App Name>\n                                    --user <userName>    \n                                    --password <password> \n\n     5)Stop Application:\n       java -jar hcli.jar -stop  --name <App Name>\n                                    --user <userName>    \n                                    --password <password> \n\n     6)Delete Application:\n       java -jar hcli.jar -delete --name <App Name>\n                                    --user <userName>    \n                                    --password <password> \n\n     7)Deploy Web/Enterprise Application:\n       java -jar hcli.jar -deploy --server <server>\n                                    --port <xxxx>\n                                    --file <file location>\n\n     8)UnDeploy Web/Enterprise  Application:\n       java -jar hcli.jar -undeploy --server <server>\n                                      --port <xxxx> \n                                      --name <Web/Enterprise Application name>";
    static String subid = "";
    static String email = "";
    static String server = "";
    static String rest = "";
    static String restURL;
    static Vector<String> nameList;
    static int cntr;
    private static Vector<String[]> productList;
    private static String user;
    private static String password;
    static String mode;
    static Vector<String> argsList;
    static String type;
    static String port;
    static String file;
    static String appname;
    static String deploy_user;
    static String deploy_password;
    static String deploy_protocol;
    static String prodid;
    public static final String DEPLOY_AUTHENTICATION_FAILURE = "Authentication failure against server while attempting to deploy/undeploy. User=>";
    static String platformSnapID;
    static String volumeID;
    static String product;
    static String instanceID;

    public static void main(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            heirloomcli.showUsage();
        }
        argsList = new Vector();
        for (n = 1; n < stringArray.length; ++n) {
            if (stringArray[n].startsWith("--")) {
                argsList.add(stringArray[n].toLowerCase());
                continue;
            }
            argsList.add(stringArray[n]);
        }
        heirloomcli.licenseLookUp();
        mode = stringArray[0];
        if (mode.compareToIgnoreCase("-list") == 0) {
            heirloomcli.checkUserPassword();
            n = argsList.indexOf("--type");
            if (n == -1) {
                type = "";
            } else {
                String string = type = n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "";
            }
            if (type.equalsIgnoreCase("apps")) {
                heirloomcli.getProducts(false);
                heirloomcli.getInstances();
                heirloomcli.getVolumes();
            } else if (type.equalsIgnoreCase("platforms")) {
                heirloomcli.getProducts(true);
            } else {
                heirloomcli.showUsage();
            }
        } else if (mode.compareToIgnoreCase("-create") == 0) {
            heirloomcli.checkUserPassword();
            n = argsList.indexOf("--productid");
            prodid = n == -1 ? "" : (n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "");
            n = argsList.indexOf("--name");
            appname = n == -1 ? "" : (n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "");
            heirloomcli.getProducts(false);
            String[] stringArray2 = heirloomcli.getProductInfo(0, prodid);
            if (appname.isEmpty()) {
                System.out.println("Application name cannot be blank");
                System.exit(0);
            }
            if (stringArray2 == null) {
                System.out.println("Invalid product id specififed");
                System.exit(0);
            }
            if (heirloomcli.CheckVolumes(appname)) {
                System.out.println("Application Name already exists.");
                System.exit(0);
            }
            String string = stringArray2[3];
            heirloomcli.getPlatformInfo(string);
            heirloomcli.createVolume();
        } else if (mode.compareToIgnoreCase("-start") == 0) {
            heirloomcli.checkUserPassword();
            n = argsList.indexOf("--name");
            if (n == -1) {
                appname = "";
            } else {
                String string = appname = n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "";
            }
            if (appname.isEmpty()) {
                System.out.println("Application name cannot be blank");
                System.exit(0);
            }
            if (!heirloomcli.CheckVolumes(appname)) {
                System.out.println("Application does not exist.");
                System.exit(0);
            }
            if (heirloomcli.CheckInstances(appname)) {
                System.out.println("Application is already running.");
                System.exit(0);
            }
            heirloomcli.startApp();
        } else if (mode.compareToIgnoreCase("-stop") == 0) {
            heirloomcli.checkUserPassword();
            n = argsList.indexOf("--name");
            if (n == -1) {
                appname = "";
            } else {
                String string = appname = n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "";
            }
            if (appname.isEmpty()) {
                System.out.println("Application name cannot be blank");
                System.exit(0);
            }
            if (!heirloomcli.CheckInstances(appname)) {
                System.out.println("Application does not exist");
                System.exit(0);
            }
            heirloomcli.stopApp();
        } else if (mode.compareToIgnoreCase("-delete") == 0) {
            heirloomcli.checkUserPassword();
            n = argsList.indexOf("--name");
            if (n == -1) {
                appname = "";
            } else {
                String string = appname = n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "";
            }
            if (appname.isEmpty()) {
                System.out.println("Application name cannot be blank");
                System.exit(0);
            }
            if (!heirloomcli.CheckVolumes(appname)) {
                System.out.println("Application does not exist.");
                System.exit(0);
            }
            heirloomcli.deleteVolume();
        } else if (mode.compareToIgnoreCase("-deploy") == 0 || mode.compareToIgnoreCase("-undeploy") == 0) {
            n = argsList.indexOf("--server");
            server = n == -1 ? "" : (n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "");
            n = argsList.indexOf("--port");
            port = n == -1 ? "" : (n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "");
            n = argsList.indexOf("--file");
            file = n == -1 ? "" : (n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "");
            n = argsList.indexOf("--name");
            if (n == -1) {
                appname = "";
            } else {
                String string = appname = n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "";
            }
            if (mode.compareToIgnoreCase("-deploy") == 0 && (server.isEmpty() || port.isEmpty() || file.isEmpty()) || mode.compareToIgnoreCase("-undeploy") == 0 && (server.isEmpty() || port.isEmpty() || appname.isEmpty())) {
                heirloomcli.showUsage();
            }
            if (mode.compareToIgnoreCase("-deploy") == 0) {
                heirloomcli.deployToServer();
            } else {
                heirloomcli.undeployFromServer();
            }
        } else {
            heirloomcli.showUsage();
        }
    }

    private static void checkUserPassword() {
        if (argsList.contains("--user") && argsList.contains("--password")) {
            int n = argsList.indexOf("--user");
            user = n == -1 ? "" : (n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "");
            n = argsList.indexOf("--password");
            password = n == -1 ? "" : (n + 1 < argsList.size() ? argsList.elementAt(n + 1) : "");
        } else {
            heirloomcli.showUsage();
        }
    }

    public static void deployToServer() {
        boolean bl = new File(file).exists();
        if (!bl) {
            System.out.println("\n\nError:File \"" + file + "\" does not exist. Exiting..");
        }
        if (port.compareToIgnoreCase("8082") == 0) {
            heirloomcli.ftpToInstance(server, port, file, "geronimo");
        }
        if (port.compareToIgnoreCase("8080") == 0) {
            heirloomcli.getWARAppSecurity(server, port);
            heirloomcli.deployToInstance(server, port, file);
        }
    }

    public static void undeployFromServer() {
        if (port.compareToIgnoreCase("8082") == 0) {
            heirloomcli.undeployFromInstance(server, port, appname, "geronimo");
        }
        if (port.compareToIgnoreCase("8080") == 0) {
            heirloomcli.getWARAppSecurity(server, port);
            heirloomcli.undeployFromApache(server, port, appname);
        }
    }

    public static void undeployFromApache(String string, String string2, String string3) {
        Authenticator authenticator = new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                Authenticator.setDefault(null);
                return null;
            }
        };
        Authenticator.setDefault(authenticator);
        if (deploy_protocol.equalsIgnoreCase("Apache Tomcat")) {
            try {
                String string4;
                String string5;
                Object object;
                String string6 = "http://" + string + ":" + string2 + "/manager/text/list";
                URL uRL = new URL(string6);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setDoInput(true);
                httpURLConnection.setRequestMethod("GET");
                if (!deploy_user.equalsIgnoreCase("")) {
                    object = "Basic " + heirloomcli.b64(deploy_user + ":" + deploy_password);
                    httpURLConnection.setRequestProperty("Authorization", (String)object);
                }
                object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                while (((BufferedReader)object).readLine() != null) {
                }
                ((BufferedReader)object).close();
                String string7 = "http://" + string + ":" + string2 + "/manager/text/undeploy?path=/" + string3;
                uRL = new URL(string7);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (!deploy_user.equalsIgnoreCase("")) {
                    string5 = "Basic " + heirloomcli.b64(deploy_user + ":" + deploy_password);
                    httpURLConnection.setRequestProperty("Authorization", string5);
                }
                object = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                string5 = "";
                while ((string4 = ((BufferedReader)object).readLine()) != null) {
                    string5 = string5 + string4;
                }
                ((BufferedReader)object).close();
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream(new StringReader(string5));
                string5 = string5.replaceAll("OK -", "\nOK -");
                string5 = string5.replaceAll("FAIL -", "\nFAIL -");
                System.out.println(string5);
                if (string5.startsWith("\nOK")) {
                    System.out.println("Application undeployed.\n\n");
                } else {
                    System.out.println("Application undeploy failed.\n\n");
                }
            }
            catch (IOException iOException) {
                if (iOException.getMessage().indexOf("401") > 0) {
                    System.out.println(DEPLOY_AUTHENTICATION_FAILURE + deploy_user);
                }
                System.out.println("Failed to deploy: " + iOException.getMessage() + "\n" + iOException.getLocalizedMessage() + "\n" + iOException.toString());
            }
        }
    }

    public static void undeployFromInstance(String string, String string2, String string3, String string4) {
        URL uRL = null;
        String string5 = "http://" + string + ":82/cgi-bin/deploy.py?serverType=" + string4 + "&undeployApp=" + string3;
        try {
            String string6;
            uRL = new URL(string5);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("POST");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string7 = "";
            String string8 = "";
            while ((string6 = bufferedReader.readLine()) != null) {
                if (string6.startsWith("DETAILS")) {
                    string8 = string8 + string6.substring(string6.indexOf(45));
                    continue;
                }
                if (string6.startsWith("INFO")) {
                    System.out.println(string6.substring(string6.indexOf(45)));
                    continue;
                }
                string7 = string7 + string6;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string7));
            if (string7.startsWith("OK")) {
                String[] stringArray = string8.split("\\\\r\\\\n");
                if (stringArray.length == 1) {
                    stringArray = string8.split("\\\\n");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println(stringArray[i].replaceAll("\\\\t", "    "));
                }
            } else {
                String[] stringArray = string8.split("\\\\r\\\\n");
                if (stringArray.length == 1) {
                    stringArray = string8.split("\\\\n");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println(stringArray[i].replaceAll("\\\\t", "    "));
                }
            }
            if (string7.startsWith("OK")) {
                System.out.println("\n\nApplication undeployed.\n\n");
            } else {
                System.out.println("\n\nApplication undeployment failed ");
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().indexOf("401") > 0) {
                System.out.println(DEPLOY_AUTHENTICATION_FAILURE + deploy_user);
            }
            System.out.println("Failed to deploy: " + iOException.getMessage() + "\n" + iOException.getLocalizedMessage() + "\n" + iOException.toString());
        }
    }

    public static void ftpToInstance(String string, String string2, String string3, String string4) {
        File file = new File(string3);
        URL uRL = null;
        String string5 = "http://" + string + ":82/cgi-bin/deploy.py?serverType=" + string4;
        try {
            String string6;
            String string7 = Long.toHexString(System.currentTimeMillis());
            String string8 = "\r\n";
            uRL = new URL(string5);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setChunkedStreamingMode((int)file.length() / 50);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string7);
            PrintWriter printWriter = null;
            httpURLConnection.setRequestMethod("POST");
            OutputStream outputStream = httpURLConnection.getOutputStream();
            printWriter = new PrintWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), true);
            printWriter.append("--" + string7).append(string8);
            printWriter.append("Content-Disposition: form-data; name=\"binaryFile\"; filename=\"" + file.getName() + "\"").append(string8);
            printWriter.append("Content-Type: " + URLConnection.guessContentTypeFromName(file.getName())).append(string8);
            printWriter.append("Content-Transfer-Encoding: binary").append(string8);
            printWriter.append(string8).flush();
            int n = (int)(file.length() / 50L);
            FileInputStream fileInputStream = new FileInputStream(string3);
            byte[] byArray = new byte[n];
            int n2 = -1;
            int n3 = 0;
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                if (n2 <= 0) continue;
                outputStream.write(byArray, 0, n2);
                outputStream.flush();
                System.out.print("\r- FTP file to Server-" + n3 + "% completed");
                n3 += 2;
            }
            System.out.println(" ");
            fileInputStream.close();
            printWriter.append(string8).flush();
            printWriter.append("--" + string7 + "--").append(string8);
            outputStream.close();
            fileInputStream.close();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string9 = "";
            String string10 = "";
            while ((string6 = bufferedReader.readLine()) != null) {
                if (string6.startsWith("DETAILS")) {
                    string10 = string10 + string6.substring(string6.indexOf(45));
                    continue;
                }
                if (string6.startsWith("INFO")) {
                    System.out.println(string6.substring(string6.indexOf(45)));
                    continue;
                }
                string9 = string9 + string6;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string9));
            String string11 = "http://" + string + ":" + string2;
            if (string9.startsWith("OK")) {
                String[] stringArray = string10.split("\\\\r\\\\n");
                if (stringArray.length == 1) {
                    stringArray = string10.split("\\\\n");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println(stringArray[i].replaceAll("\\\\t", "    "));
                }
            } else {
                String[] stringArray = string10.split("\\\\r\\\\n");
                if (stringArray.length == 1) {
                    stringArray = string10.split("\\\\n");
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.println(stringArray[i].replaceAll("\\\\t", "    "));
                }
            }
            if (string9.startsWith("OK")) {
                System.out.println("\n\nApplication successfully deployed to:\n\n" + string11);
            } else {
                System.out.println("\n\nApplication deployment failure to:\n\n" + string + ":" + string2);
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().indexOf("401") > 0) {
                System.out.println(DEPLOY_AUTHENTICATION_FAILURE + deploy_user);
            }
            System.out.println("Failed to deploy: " + iOException.getMessage() + "\n" + iOException.getLocalizedMessage() + "\n" + iOException.toString());
        }
    }

    public static void deployToInstance(String string, String string2, String string3) {
        Authenticator authenticator = new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                Authenticator.setDefault(null);
                return null;
            }
        };
        Authenticator.setDefault(authenticator);
        if (deploy_protocol.equalsIgnoreCase("Apache Tomcat")) {
            try {
                String string4;
                Object object;
                Object object2;
                String string5 = "http://" + string + ":" + string2 + "/manager/text/list";
                URL uRL = new URL(string5);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setDoInput(true);
                httpURLConnection.setRequestMethod("GET");
                if (!deploy_user.equalsIgnoreCase("")) {
                    object2 = "Basic " + heirloomcli.b64(deploy_user + ":" + deploy_password);
                    httpURLConnection.setRequestProperty("Authorization", (String)object2);
                }
                object2 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                while (((BufferedReader)object2).readLine() != null) {
                }
                ((BufferedReader)object2).close();
                string3 = string3.replaceAll("\\\\", "/");
                File file = new File(string3);
                String string6 = string3.substring(string3.lastIndexOf(47), string3.lastIndexOf(46));
                String string7 = "http://" + string + ":" + string2 + "/manager/text/deploy?path=" + string6 + "&update=true";
                uRL = new URL(string7);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (!deploy_user.equalsIgnoreCase("")) {
                    object = "Basic " + heirloomcli.b64(deploy_user + ":" + deploy_password);
                    httpURLConnection.setRequestProperty("Authorization", (String)object);
                }
                httpURLConnection.setFixedLengthStreamingMode((int)file.length());
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.setRequestMethod("PUT");
                httpURLConnection.setRequestProperty("Content-Type", "application/octet-stream");
                object = httpURLConnection.getOutputStream();
                int n = (int)(file.length() / 50L);
                FileInputStream fileInputStream = new FileInputStream(string3);
                byte[] byArray = new byte[n];
                int n2 = -1;
                int n3 = 0;
                while ((n2 = fileInputStream.read(byArray)) != -1) {
                    if (n2 <= 0) continue;
                    ((OutputStream)object).write(byArray, 0, n2);
                    ((OutputStream)object).flush();
                    System.out.print("\r- FTP file to Server-" + n3 + "% completed");
                    n3 += 2;
                }
                System.out.println(" ");
                fileInputStream.close();
                ((OutputStream)object).close();
                fileInputStream.close();
                object2 = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                String string8 = "";
                while ((string4 = ((BufferedReader)object2).readLine()) != null) {
                    string8 = string8 + string4;
                }
                ((BufferedReader)object2).close();
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream(new StringReader(string8));
                string8 = string8.replaceAll("OK -", "\nOK -");
                string8 = string8.replaceAll("FAIL -", "\nFAIL -");
                System.out.println(string8);
                String string9 = "http://" + string + ":" + string2 + string6 + "/";
                if (string8.startsWith("\nOK")) {
                    System.out.println("Application successfully deployed to:\n\n" + string9 + "\n\n");
                } else {
                    System.out.println("Application deploy failed.\n\n");
                }
            }
            catch (IOException iOException) {
                if (iOException.getMessage().indexOf("401") > 0) {
                    System.out.println(DEPLOY_AUTHENTICATION_FAILURE + deploy_user);
                }
                System.out.println("Failed to deploy: " + iOException.getMessage() + "\n" + iOException.getLocalizedMessage() + "\n" + iOException.toString());
            }
        }
    }

    private static void getWARAppSecurity(String string, String string2) {
        block6: {
            try {
                String string3;
                URL uRL = new URL("https://" + rest + "connect" + heirloomcli.getTimeStamp() + "&generate=xml");
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
                httpsURLConnection.setRequestProperty("HC_SUBSCRIPTION_ID", subid);
                httpsURLConnection.setRequestProperty("HC_EMAIL_ADDRESS", email);
                httpsURLConnection.setConnectTimeout(30000);
                httpsURLConnection.setReadTimeout(30000);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
                String string4 = "";
                while ((string3 = bufferedReader.readLine()) != null) {
                    string4 = string4 + string3;
                }
                bufferedReader.close();
                InputSource inputSource = new InputSource();
                inputSource.setCharacterStream(new StringReader(string4));
                Document document = null;
                document = heirloomcli.parseXmlString(inputSource);
                if (document == null) break block6;
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("connect");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String string5 = element.getAttribute("status");
                    String string6 = heirloomcli.getTagValue("dns", element);
                    String string7 = heirloomcli.getTagValue("externalip", element);
                    if (!string5.equalsIgnoreCase("running") || !string.equalsIgnoreCase(string6) && !string.equalsIgnoreCase(string7)) continue;
                    String string8 = null;
                    string8 = heirloomcli.getTagValue("servlet_container_deploy_port", element);
                    if (string8.equalsIgnoreCase(string2)) {
                        deploy_user = heirloomcli.getTagAttributeValue("servlet_container_deploy_port", "sc_user", element);
                        deploy_password = heirloomcli.getTagAttributeValue("servlet_container_deploy_port", "sc_password", element);
                        deploy_protocol = heirloomcli.getTagAttributeValue("servlet_container_deploy_port", "sc_protocol", element);
                    } else {
                        deploy_user = heirloomcli.getTagAttributeValue("application_server_deploy_port", "sc_user", element);
                        deploy_password = heirloomcli.getTagAttributeValue("application_server_deploy_port", "sc_password", element);
                        deploy_protocol = heirloomcli.getTagAttributeValue("application_server_deploy_port", "sc_protocol", element);
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("\nFailure to obtain Web Security Indormation:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
            }
        }
    }

    private static void showUsage() {
        System.out.println(Usage);
        System.exit(0);
    }

    private static String getTimeStamp() {
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        simpleDateFormat.setTimeZone(timeZone);
        String string = simpleDateFormat.format(date);
        String string2 = "?timestamp=" + string;
        return string2;
    }

    private static void licenseLookUp() {
        String string = System.getProperty("user.home");
        String string2 = Services.class.getProtectionDomain().getCodeSource().getLocation().getPath().replaceFirst("com/heirloomcomputing/ecc/Services.class", "/").replaceFirst("/ecobol.jar", "/").replaceFirst("/WEB-INF/lib", "/").replaceAll("%20", " ");
        Properties properties = null;
        try {
            properties = new Properties();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Licensing issue - unable to read properties file ");
        }
        try {
            properties.load(new FileInputStream("elasticcobol.properties"));
        }
        catch (IOException iOException) {
            try {
                properties.load(new FileInputStream(string + File.separator + "elasticcobol.properties"));
            }
            catch (IOException iOException2) {
                try {
                    properties.load(new FileInputStream(string2 + "elasticcobol.properties"));
                }
                catch (IOException iOException3) {
                    JOptionPane.showMessageDialog(null, "Unable to locate elasticcobol.properties file containing your subscription information.\n");
                }
            }
        }
        subid = properties.getProperty("elasticcobol.subscription_id");
        email = properties.getProperty("elasticcobol.email_address");
        rest = properties.getProperty("elasticcobol.rest");
        if (rest == null || rest.trim().isEmpty()) {
            rest = "https://paas.heirloomcomputing.com/rest/2018-01-01/connect".replaceAll("connect", "");
            rest = rest.replaceAll("https://", "");
        } else if (!rest.startsWith("test.elasticcobol.com/rest/") && !rest.startsWith("www.elasticcobol.com/rest/")) {
            System.out.println("The rest flag in elasticcobol.properties file is incorrect.\n\n\"" + rest + "\". \n\n A valid flag should be as follows:\n\n\"test.elasticcobol.com/rest/[...]\"  Or \n\n \"www.elasticcobol.com/rest/[...]\" ");
            rest = "";
            return;
        }
    }

    private static Document parseXmlString(InputSource inputSource) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    private static String getTagValue(String string, Element element) {
        try {
            NodeList nodeList = element.getElementsByTagName(string);
            if (nodeList == null) {
                return "";
            }
            nodeList = element.getElementsByTagName(string).item(0).getChildNodes();
            if (nodeList == null) {
                return "";
            }
            Node node = nodeList.item(0);
            if (node == null) {
                return "";
            }
            return node.getNodeValue();
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String getTagAttributeValue(String string, String string2, Element element) {
        Node node = element.getElementsByTagName(string).item(0);
        if (node.getNodeType() == 1) {
            Element element2 = (Element)node;
            String string3 = element2.getAttribute(string2);
            if (string3 == null) {
                return "";
            }
            return string3;
        }
        return "";
    }

    private static String b64(String string) {
        String string2 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz01234567890+/";
        int n = string.length();
        int n2 = (n * 4 + 2) / 3;
        String string3 = "";
        int n3 = 0;
        int n4 = n;
        int n5 = 0;
        while (n3 < n4) {
            int n6 = string.charAt(n3++) & 0xFF;
            int n7 = n3 < n4 ? string.charAt(n3++) & 0xFF : 0;
            int n8 = n3 < n4 ? string.charAt(n3++) & 0xFF : 0;
            int n9 = n6 >>> 2;
            int n10 = (n6 & 3) << 4 | n7 >>> 4;
            int n11 = (n7 & 0xF) << 2 | n8 >>> 6;
            int n12 = n8 & 0x3F;
            string3 = string3 + string2.charAt(n9);
            ++n5;
            string3 = string3 + string2.charAt(n10);
            string3 = string3 + (++n5 < n2 ? Character.valueOf(string2.charAt(n11)) : "=");
            string3 = string3 + (++n5 < n2 ? Character.valueOf(string2.charAt(n12)) : "=");
            ++n5;
        }
        return string3;
    }

    public static void getProducts(boolean bl) {
        productList = new Vector();
        int n = 1;
        try {
            String string;
            URL uRL = new URL("https://" + rest + "product" + heirloomcli.getTimeStamp() + "&expanded=True");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("GET");
            String string2 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string3 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string3 = string3 + string;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string3));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("product");
                if (bl) {
                    System.out.println("\nProduct# \tProduct Details");
                    System.out.println("\n-------- \t---------------");
                }
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    if (bl) {
                        String string4 = heirloomcli.getTagValue("architecture", element);
                        System.out.println("\n[" + n + "]   \t\tProductID:" + heirloomcli.getTagValue("productid", element) + "\n   \t\tProductTitle:" + heirloomcli.getTagValue("productTitle", element) + (string4.isEmpty() ? "" : "\t(" + string4 + ")") + "\n   \t\tPeriod:" + heirloomcli.getTagValue("period", element));
                    } else {
                        productList.add(new String[]{heirloomcli.getTagValue("productid", element), heirloomcli.getTagValue("productTitle", element), heirloomcli.getTagValue("architecture", element), heirloomcli.getTagValue("cloud_image_guid", element)});
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Products:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
        }
    }

    public static boolean CheckInstances(String string) {
        try {
            String string2;
            URL uRL = new URL("https://" + rest + "instance" + heirloomcli.getTimeStamp() + "&expanded=True");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("GET");
            String string3 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string4 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                string4 = string4 + string2;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string4));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("instance");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    instanceID = heirloomcli.getTagValue("id", element);
                    if (!string.equalsIgnoreCase(heirloomcli.getTagValue("tag", element))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Check Instances:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
            System.exit(0);
            return true;
        }
    }

    public static void startApp() {
        try {
            String string;
            URL uRL = new URL("https://" + rest + "instance" + heirloomcli.getTimeStamp() + "&product=" + product + "&tag=" + appname);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("PUT");
            String string2 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string3 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string3 = string3 + string;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string3));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                Element element;
                String string4;
                Node node;
                int n;
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("instanceresponse");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n);
                    if (node.getNodeType() != 1 || (string4 = (element = (Element)node).getAttribute("scope")).equalsIgnoreCase("started")) continue;
                    System.out.println("Failure to start Application");
                }
                document.getDocumentElement().normalize();
                nodeList = document.getElementsByTagName("instance");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n);
                    if (node.getNodeType() != 1) continue;
                    element = (Element)node;
                    string4 = "";
                    string4 = heirloomcli.getTagValue("id", element);
                    System.out.println("Started Application " + appname + " with id :" + string4);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Start Instances:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
            System.exit(0);
        }
    }

    public static void stopApp() {
        try {
            String string;
            URL uRL = new URL("https://" + rest + "instance/" + instanceID + heirloomcli.getTimeStamp());
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("DELETE");
            String string2 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string3 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string3 = string3 + string;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string3));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                Element element;
                String string4;
                Node node;
                int n;
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("instanceresponse");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n);
                    if (node.getNodeType() != 1 || (string4 = (element = (Element)node).getAttribute("scope")).equalsIgnoreCase("deleted")) continue;
                    System.out.println("Failure to stop Application");
                }
                document.getDocumentElement().normalize();
                nodeList = document.getElementsByTagName("instance");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n);
                    if (node.getNodeType() != 1) continue;
                    element = (Element)node;
                    string4 = "";
                    string4 = heirloomcli.getTagValue("status", element);
                    System.out.println("Application Status:" + string4);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Stop Instances:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
            System.exit(0);
        }
    }

    public static boolean CheckVolumes(String string) {
        try {
            String string2;
            URL uRL = new URL("https://" + rest + "volume" + heirloomcli.getTimeStamp() + "&expanded=True");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("GET");
            String string3 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string4 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                string4 = string4 + string2;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string4));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("volume");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    volumeID = heirloomcli.getTagValue("id", element);
                    product = heirloomcli.getTagValue("product", element);
                    if (!string.equalsIgnoreCase(heirloomcli.getTagValue("tag", element))) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Check Volumes:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
            System.exit(0);
            return true;
        }
    }

    public static void getVolumes() {
        try {
            String string;
            URL uRL = new URL("https://" + rest + "volume" + heirloomcli.getTimeStamp() + "&expanded=True");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("GET");
            String string2 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string3 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string3 = string3 + string;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string3));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("volume");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String string4 = "Not in Use";
                    String string5 = heirloomcli.getTagValue("tag", element);
                    if (nameList.contains(string5)) continue;
                    String[] stringArray = heirloomcli.getProductInfo(0, heirloomcli.getTagValue("product", element));
                    String string6 = stringArray == null ? "" : stringArray[2];
                    String string7 = stringArray[1];
                    System.out.println("\n[" + ++cntr + "]\tName:" + string5 + "\n\tProduct:" + string7 + (string6.isEmpty() ? "" : "\t(" + string6 + ")") + "\n\tStatus:" + string4 + (string4.compareToIgnoreCase("running") == 0 ? "\n\tIP Address:" + heirloomcli.getTagValue("externalip", element) : "") + (string4.compareToIgnoreCase("running") == 0 ? "\n\tDNS:" + heirloomcli.getTagValue("dns", element) : "") + "\n\tOwner:" + email);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Volumes:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
        }
    }

    public static void getPlatformInfo(String string) {
        productList = new Vector();
        try {
            String string2;
            URL uRL = new URL("https://" + rest + "platform/" + string + heirloomcli.getTimeStamp() + "&expanded=True");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("GET");
            String string3 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string3);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string4 = "";
            while ((string2 = bufferedReader.readLine()) != null) {
                string4 = string4 + string2;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string4));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("platform");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    platformSnapID = heirloomcli.getTagValue("volume", element);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Platform Snap ID:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
        }
    }

    public static void getInstances() {
        try {
            String string;
            URL uRL = new URL("https://" + rest + "connect" + heirloomcli.getTimeStamp() + "&generate=xml");
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setRequestProperty("HC_SUBSCRIPTION_ID", subid);
            httpsURLConnection.setRequestProperty("HC_EMAIL_ADDRESS", email);
            httpsURLConnection.setConnectTimeout(30000);
            httpsURLConnection.setReadTimeout(30000);
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("GET");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string2 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string2 + string;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string2));
            Document document = null;
            nameList = new Vector();
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("connect");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String string3 = element.getAttribute("status");
                    String string4 = heirloomcli.getTagValue("application", element);
                    ++cntr;
                    String[] stringArray = heirloomcli.getProductInfo(1, heirloomcli.getTagValue("product", element));
                    String string5 = stringArray == null ? "" : stringArray[2];
                    String string6 = null;
                    String string7 = null;
                    String string8 = null;
                    String string9 = null;
                    string6 = heirloomcli.getTagValue("servlet_container_deploy_port", element);
                    string8 = heirloomcli.getTagValue("application_server_deploy_port", element);
                    string7 = string6.isEmpty() ? null : heirloomcli.getTagAttributeValue("servlet_container_deploy_port", "sc_protocol", element);
                    string9 = string8.isEmpty() ? null : heirloomcli.getTagAttributeValue("application_server_deploy_port", "as_protocol", element);
                    System.out.println("\n[" + cntr + "]\tName:" + string4 + "\n\tProduct:" + heirloomcli.getTagValue("product", element) + (string5.isEmpty() ? "" : "\t(" + string5 + ")") + "\n\tStatus:" + string3 + (string3.compareToIgnoreCase("running") == 0 ? "\n\tIP Address:" + heirloomcli.getTagValue("externalip", element) : "") + (string3.compareToIgnoreCase("running") == 0 ? "\n\tDNS:" + heirloomcli.getTagValue("dns", element) : "") + (string3.compareToIgnoreCase("running") == 0 ? (string6 != null && string7 != null ? "\n\tServlet Deployment:" + string7 + " [" + string6 + "]" : "") : "") + (string3.compareToIgnoreCase("running") == 0 ? (string8 != null && string9 != null ? "\n\tApplication Deployment:" + string9 + " [" + string8 + "]" : "") : "") + "\n\tOwner:" + heirloomcli.getTagValue("owner", element));
                    nameList.add(string4);
                }
            }
            httpsURLConnection.disconnect();
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Instances:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
        }
    }

    public static void createVolume() {
        try {
            String string;
            URL uRL = new URL("https://" + rest + "volume" + heirloomcli.getTimeStamp() + "&product=" + prodid + "&subscription_id=" + subid + "&iaas_snap=" + platformSnapID + "&tag=" + appname);
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("PUT");
            String string2 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string3 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string3 = string3 + string;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string3));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                Element element;
                String string4;
                Node node;
                int n;
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("volumeresponse");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n);
                    if (node.getNodeType() != 1 || (string4 = (element = (Element)node).getAttribute("scope")).equalsIgnoreCase("new")) continue;
                    System.out.println("Failure to create Application");
                }
                document.getDocumentElement().normalize();
                nodeList = document.getElementsByTagName("volume");
                for (n = 0; n < nodeList.getLength(); ++n) {
                    node = nodeList.item(n);
                    if (node.getNodeType() != 1) continue;
                    element = (Element)node;
                    string4 = "";
                    string4 = heirloomcli.getTagValue("id", element);
                    System.out.println("\nCreated Application " + appname + " with id :" + string4);
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Create Volumes:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
        }
    }

    public static void deleteVolume() {
        try {
            String string;
            URL uRL = new URL("https://" + rest + "volume/" + volumeID + heirloomcli.getTimeStamp());
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setRequestMethod("DELETE");
            String string2 = "Basic " + heirloomcli.b64(user + ":" + password);
            httpsURLConnection.setRequestProperty("Authorization", string2);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpsURLConnection.getInputStream()));
            String string3 = "";
            while ((string = bufferedReader.readLine()) != null) {
                string3 = string3 + string;
            }
            bufferedReader.close();
            InputSource inputSource = new InputSource();
            inputSource.setCharacterStream(new StringReader(string3));
            Document document = null;
            document = heirloomcli.parseXmlString(inputSource);
            if (document != null) {
                document.getDocumentElement().normalize();
                NodeList nodeList = document.getElementsByTagName("volumeresponse");
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element element = (Element)node;
                    String string4 = element.getAttribute("scope");
                    if (string4.equalsIgnoreCase("deleted")) {
                        System.out.println("Application Deleted");
                        continue;
                    }
                    System.out.println("Application Deletion Failure");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("\nFailure to get Delete Volumes:\n" + exception.getMessage() + exception.getLocalizedMessage() + exception.toString());
        }
    }

    private static String[] getProductInfo(int n, String string) {
        for (String[] stringArray : productList) {
            if (!string.equalsIgnoreCase(stringArray[n])) continue;
            return stringArray;
        }
        return null;
    }

    static {
        cntr = 0;
        user = "";
        password = "";
        prodid = null;
        platformSnapID = "";
        product = "";
        instanceID = "";
    }
}

