       IDENTIFICATION DIVISION.
       PROGRAM-ID. %PID%.

       DATA DIVISION.
       WORKING-STORAGE SECTION.

      * Constants

       78 VALUE-EXIT    PIC 99 VALUE 50.
       78 VALUE-ABOUT   PIC 99 VALUE 51.
       78 VALUE-OK      PIC 99 VALUE 52.
       78 VALUE-CANCEL  PIC 99 VALUE 53.

      * Variables

       77 SCREEN-VALUE  PIC S999 IS SPECIAL-NAMES CRT STATUS.

       SCREEN SECTION.

       01 MAIN-SCREEN.

           05 MAIN-MENU IS MENU
              .
           05 MAIN-OK-BUTTON IS PUSH-BUTTON OK-BUTTON 
              LINE 22 COLUMN 60 
              TERMINATION-VALUE = VALUE-OK
              .
           05 MAIN-CANCEL-BUTTON IS PUSH-BUTTON CANCEL-BUTTON
              COLUMN PLUS 2
              EXCEPTION-VALUE = VALUE-CANCEL
              .

       PROCEDURE DIVISION.
       BUILD-SCREEN.

      * Create the main window
           DISPLAY STANDARD WINDOW TITLE "Window Title" 
               LINES = 25 SIZE = 80
    
      * Create the main window menu    
           PERFORM BUILD-MENU
           .
    
       DISPLAY-LOOP.

      * Display and accept the main screen

           DISPLAY MAIN-SCREEN
           ACCEPT MAIN-SCREEN

      * Evaluate the return from the accept of the screen    

           EVALUATE SCREEN-VALUE
               WHEN VALUE-EXIT PERFORM DO-EXIT
               WHEN VALUE-ABOUT PERFORM DO-ABOUT
               WHEN VALUE-OK PERFORM DO-OK
               WHEN VALUE-CANCEL PERFORM DO-CANCEL
           END-EVALUATE
           GO TO DISPLAY-LOOP
           .

       DO-ABOUT.
           DISPLAY MESSAGE BOX "Graphical Program" & x"0a" 
                   & "About Message"
           .
    
       DO-OK.
           DISPLAY MESSAGE BOX "Graphical Program" & x"0a" 
                   & "OK Message"
           .
    
       DO-CANCEL.
           DISPLAY MESSAGE BOX "Graphical Program" & x"0a" 
                   & "Cancel Message"
           .
    
       DO-EXIT.
           STOP ALL RUN
           .
    
       BUILD-MENU.
           MODIFY MAIN-MENU
    
               BEGIN-MENU = "&File"
                   ITEM-TO-ADD = "E&xit" 
                       TERMINATION-VALUE = VALUE-EXIT
               END-MENU
        
               BEGIN-MENU = "&Help"
                   ITEM-TO-ADD = "&About" 
                       TERMINATION-VALUE = VALUE-ABOUT
               END-MENU
           .
