      $SET SOURCEFORMAT "VARIABLE"
       IDENTIFICATION DIVISION.
       PROGRAM-ID. %PID%.

       DATA DIVISION.
       WORKING-STORAGE SECTION.

       EXEC SQL BEGIN DECLARE SECTION END-EXEC

      * SQLCODE is 0 for success, 100 for no data, -1 for failure
       77 SQLCODE PIC S9(3). 
       
      * SQLSTATE is a 5 character communication code; 00xxx is success.
       77 SQLSTATE PIC X(5). 

       EXEC SQL END DECLARE SECTION END-EXEC

       PROCEDURE DIVISION.
       MAIN-PARAGRAPH.
      * Initial code
           PERFORM DO-CONNECT
      * Use the database    
           PERFORM DO-DISCONNECT
      * Terminate the program    
           GOBACK
           .

      * The SQL connect statement must be completed with the information
      * appropriate to the actual JDBC driver in use.  JDBC stands for
      * Java DataBase Connectivity, and it is the method by which Elastic COBOL
      * accesses databases and database-like data sources.
      *
      * The JDBC driver itself must be included in the Java library path
      * in order to successfully connect to the database.  The JDBC driver
      * is generally included with the database itself; see the database
      * documentation for more details.
      *
      * When connecting to a datasource, the jdbc:url may be 
      * ds:data-source-name.
      *
      * jdbc:url		The JDBC url to the database itself
      * user			Usually USER     :cobol-variable-name
      * password		Usually PASSWORD :cobol-variable-name
      * com.driver.name	This is the classname of the driver
      *
       DO-CONNECT.
           EXEC SQL
               CONNECT
               	TO "jdbc:url"
               	USER "user"
               	PASSWORD "password"
               	DRIVER "com.driver.name"
           END-EXEC
           .

      * Disconnect from the SQL database connection.  This allows the
      * JDBC driver to free any resources required for the connection.

        DO-DISCONNECT.
           EXEC SQL
               DISCONNECT
           END-EXEC
           .
