Ext.Loader.setConfig({enabled: true});
Ext.namespace('heirloom');

Ext.Loader.setPath('Ext.ux', 'extjs/ux');

Ext.require([
    'Ext.grid.*',
    'Ext.data.*',
    'Ext.util.*',
    'Ext.tip.QuickTipManager',
    'Ext.ux.GMapPanel'
]);

Ext.onReady(function() {    
    Ext.QuickTips.init();
    gMapReady = false;

    // change this URL to the url you deployed the application to.
    var doc = document.location.href;
    split=doc.split("/")
    var service_url = split.slice(0, split.length - 2).join("/") + "/servlet";
        
    /* loadSpecific - load a specific users record using account number
     * record - data record from the grid of type store
     */
    function loadSpecific(record) {
    	getACDIScreen();
        Ext.Ajax.request({
             url : service_url+"?transid=ACDI&scode=SD",
             type : 'POST',
             cors: true,
             useDefaultXhrHeader: false,
             withCredentials: true,
             params: {
	    		 "DFH_CURSOR":"ACCTD",
	    		 "ACCTD":record.data.account, 	
	    		 "DFH_ENTER":"Enter"
             },
             timeout: 120000,
             dataType : "json",
             async : true,
             method : 'POST',
             headers : { "Accept" : "application/json" },
             waitTitle:'Connecting',
             waitMsg:'Sending data...',
             success : function(output) {
                var dq = Ext.DomQuery;
                txt = output.responseText
	    		txt=txt.replace(",\n               ]","]\n")
	    		jsdata=Ext.getCmp('jsondata')
                jsdata.setValue(jsdata.getValue()+output.responseText)
                var obj = JSON.parse(txt)

		
                tel = obj["form"]["fields"][24].value 
      
              
				Ext.getCmp('det_first').setValue(record.data.first.trim())
				Ext.getCmp('det_last').setValue(record.data.surname.trim())
				Ext.getCmp('det_addr').setValue(record.data.address.trim())
				Ext.getCmp('det_tel').setValue(tel.trim())
				
				Ext.getCmp('det_cardcount').setValue(obj["form"]["fields"][42].value .trim())
				Ext.getCmp('det_limit').setValue(obj["form"]["fields"][65].value .trim())
				Ext.getCmp('det_code').setValue(obj["form"]["fields"][51].value .trim())
				yr=obj["form"]["fields"][46].value .trim()
				mth=obj["form"]["fields"][44].value .trim()
				day=obj["form"]["fields"][45].value .trim()
				Ext.getCmp('det_issued').setValue("20"+yr+"/"+mth+"/"+day)
				Ext.getCmp('det_approved').setValue(obj["form"]["fields"][54].value .trim())

				frwin.show()
				map=Ext.getCmp("gmap")
				map.fireEvent('show')
				gridpanel.setLoading(false)
	
             },
             error : function(response) {
            	 gridpanel.setLoading(false)
            	 Ext.Msg.alert('Error','Unable to contact server');
             }
         });
    }   


    function pad(num, size) {
        var s = num+"";
        while (s.length < size) s = "0" + s;
        return s;
    }
    
    /* loadSetOfAccounts - send an name to the servlet and get back the first screen of accounts
    * calls loadMoreAccounts to retrieve the full list
    */
    function loadSetOfAccounts(val) {
    	Ext.Ajax.request({
             url : service_url,
             type : 'POST',
             cors: true,
    	     useDefaultXhrHeader: false,
    	     withCredentials: true,
             params: {
				"DFH_CURSOR":"SNAMEM",
				"SNAMEM":val,
				"FNAMEM":"",
				"DFH_ENTER":"Enter"
            },
            timeout: 120000,
            dataType : "json",
            async : true,
            method : 'POST',
            headers : { "Accept" : "application/json" },
            waitTitle:'Connecting',
            waitMsg:'Sending data...',
            success : function(output) {
            	var dq = Ext.DomQuery;
                jsdata=Ext.getCmp('jsondata')
                jsdata.setValue(jsdata.getValue()+output.responseText)
                var obj = JSON.parse(output.responseText)
    
                // load grid with data
		        startingcount=091;
		        store = gridpanel.getStore()
		        store.removeAll()
        
		        // loop for the 6 records displayed on screen
		        for(i=1;i<15;i++) {
		            addr=''
		            name="LINE" + pad(i,2)
		            // find the correct line in the JSON
		            obj.form.fields.forEach(function(loop){ if (loop.id==name) { s=loop.value } });
		            if (s != '') {
						// break up the data
		            	sarray=[]
						spaceyarray=s.split(' ')
						// create an array without a bunch of blank spaces
						spaceyarray.forEach(function(item) { if(item!=""){sarray.push(item)}} );
						// loop the array and build the address
						for (loop = 5;loop<sarray.length-1;loop++) {
							addr+=sarray[loop];
							addr+=' ' 
						}
						store.add({
							account:sarray[0],
							surname:sarray[1],
							first:sarray[2],
							ttl:sarray[4],
							address:addr,
							limit:sarray[sarray.length-1]
						})
					}
		        }
		        // load the rest of accounts (not asynchronously
		        loadMoreAccounts();
		        gridpanel.setLoading(false)

             },
             error : function(response) {
            	 gridpanel.setLoading(false)
                 Ext.Msg.alert('Error','Unable to contact server');
             }
    	});
    }
     
     
     /* loadMoreAccounts - send a PF2 to navigate forward and collect the next set of accounts
      *  loop until no more records
      */
     function loadMoreAccounts() {
    	 Ext.Ajax.request({
    		 url : service_url,
             type : 'POST',
             cors: true,
     	     useDefaultXhrHeader: false,
     	     withCredentials: true,
             params: {
				 "DFH_CURSOR":"SNAMEM",
				 "DFH_PF8":"PF8"
             },
             timeout: 120000,
             dataType : "json",
             async : false,
             method : 'POST',
             headers : { "Accept" : "application/json" },
             waitTitle:'Connecting',
             waitMsg:'Sending data...',
             success : function(output) {
            	 var dq = Ext.DomQuery;
                 jsdata=Ext.getCmp('jsondata')
                 jsdata.setValue(jsdata.getValue()+output.responseText)
                 var obj = JSON.parse(output.responseText)
       
                 bEmpty=false;
                 // for each account on screen
		         for(i=1;i<15;i++) {
		             addr=''
		             name="LINE" + pad(i,2)
		             obj.form.fields.forEach(function(loop){ if (loop.id==name) { s=loop.value } });
		             if (s != '') { 
		 				// break up the data
		             	sarray=[]
		 				spaceyarray=s.split(' ')
		 				// remove extra spaces and create a tight array
		 				spaceyarray.forEach(function(item) {if(item!=""){sarray.push(item)}} );
		 				// build address from array
		 				for (loop = 5;loop<sarray.length-1;loop++) {
		 					addr+=sarray[loop];
		 					addr+=' ' 
		 				}
		 				// check store for existing account
		 				if(store.find('account',sarray[0])==-1) {
			 				store.add({
				 				account:sarray[0],
				 				surname:sarray[1],
				 				first:sarray[2],
				 				ttl:sarray[4],
				 				address:addr,
				 				limit:sarray[sarray.length-1]
			 				})
			             } 
		             } else {
		            	 bEmpty=true;
		             }
		         }
		         if (bEmpty==false)
		        	 loadMoreAccounts();
             },
             error : function(response) {
				 gridpanel.setLoading(false)
			     Ext.Msg.alert('Error','Unable to contact server');
             }
    	 });
     }
       

     /* sendPF3 - send the PF3 key to the application to ensure we're at the main menu
     * 
     */
     function sendPF3() {
        Ext.Ajax.request({
             url : service_url,
             type : 'POST',
             cors: true,
    	     useDefaultXhrHeader: false,
    	     withCredentials: true,
             params: {
				"DFH_CURSOR":"SNAMEM",
				"SNAMEM":"",
				"FNAMEM":"",
				"ACCTSM":"",
				"SNAMEM2":"",
				"FNAMEM2":"",
				"REQM":"",
				"ACCTM":"",
				"PRTRM":"",
				"DFH_PF3":"PF3"
             },
             timeout: 120000,
             dataType : "json",
             async : true,
             method : 'POST',
             headers : { "Accept" : "application/json" },
             waitTitle:'Connecting',
             waitMsg:'Sending data...',
             success : function(output) {
                var dq = Ext.DomQuery;
                jsdata=Ext.getCmp('jsondata')
                jsdata.setValue(jsdata.getValue()+output.responseText)
                var obj = JSON.parse(output.responseText)
             },
             error : function(response) {
                 Ext.Msg.alert('Error','Unable to contact server');
             }
         });
     }

     /* connectToServlet - connect to the servlet and then send a request for the first set of accounts
     * 
     */
     function connectToServlet(val) {
    	gridpanel.show();
    	gridpanel.setLoading("Loading")
    	Ext.getCmp('loadbutton').hide();
    	jsdata=Ext.getCmp('jsondata')
    	jsfs=Ext.getCmp('jsondatafieldset')
    	jsfs.show();
        Ext.Ajax.request({
        	url : service_url+"?transid=ACSN",
            type : 'GET',
            cors: true,
		    useDefaultXhrHeader: false,
		    withCredentials: true,
            timeout: 120000,
            dataType : "json",
            async : true,
            method : 'GET',
            headers : { "Accept" : "application/json" },
            waitTitle:'Connecting',
            waitMsg:'Sending data...',
            success : function(output) {
            	var dq = Ext.DomQuery;
                jsdata=Ext.getCmp('jsondata')
                jsdata.setValue(jsdata.getValue()+output.responseText)
                var obj = JSON.parse(output.responseText)    
                gridpanel.getStore().removeAll()
                loadSetOfAccounts(val)
            },
            error : function(response) {
            	Ext.Msg.alert('Error','Unable to contact server');
            }
        });
     }
     
     function getACDIScreen() {
     	gridpanel.show();
     	gridpanel.setLoading("Loading")
     	Ext.getCmp('loadbutton').hide();
     	jsdata=Ext.getCmp('jsondata')
     	jsfs=Ext.getCmp('jsondatafieldset')
     	jsfs.show();
         Ext.Ajax.request({
         	url : service_url+"?transid=ACDI",
             type : 'GET',
             cors: true,
 		    useDefaultXhrHeader: false,
 		    withCredentials: true,
             timeout: 120000,
             dataType : "json",
             async : false,
             method : 'GET',
             headers : { "Accept" : "application/json" },
             waitTitle:'Connecting',
             waitMsg:'Sending data...',
             success : function(output) {
             	var dq = Ext.DomQuery;
             	gridpanel.setLoading(false);
             },
             error : function(response) {
            	 gridpanel.setLoading(false);
             	Ext.Msg.alert('Error','Unable to contact server');
             }
         });
      }

    
     // create the data store that holds the account information retrieved from the servlet
     // used to populate the grid of data
     var store = Ext.create('Ext.data.ArrayStore', {
    	 fields: [
    		 {name: 'account'},
    		 {name: 'surname'},
    		 {name: 'first'},
    		 {name: 'ttl'},
    		 {name: 'address'},
    		 {name: 'limit'}
    	 ],
    	 data: []
     });
    
     // create the Grid that holds the account data
     gridpanel=Ext.create('Ext.grid.Panel', {
    	 store: store,
    	 hidden: true,
    	 columnLines: true,
    	 anchor: "100%",
    	 columns: [
            {
	            text     : 'Account Number',
	            width    : 50,
	            sortable : true,
	            dataIndex: 'account'
                
            },{
                text     : 'Surname',
                width    : 100,
                sortable : true,
                dataIndex: 'surname'
            },{
                text     : 'First Name',
                width    : 76,
                sortable : true,
                dataIndex: 'first'
            },{
                text     : 'Title',
                width    : 50,
                sortable : true,
                dataIndex: 'ttl'
            },{
                text     : 'Address',
                width    : 200,
                sortable : true,
                dataIndex: 'address',
                flex:true
            },{
                text     : 'Limit',
                width    : 106,
                sortable : true,
                dataIndex: 'limit'
            }
        ],
        height: 350,
        anchor: '45%',
        title: 'Customers',
        viewConfig: {
        	stripeRows: true,
            listeners: {
                itemdblclick: function(dataview, record, item, index, e) {
                	// load customer data on double click
                	loadSpecific(record);	
                }
            }
        }
     });

    
    // create the main screen panel
    Ext.create('Ext.form.Panel', {
    	layout: 'anchor',
	    title: 'Heirloom Account demo',
	    id: "MainForm",
        width: "1024px",
        height: 768,
        scrollable:true,
        frame:true,
	    bodyStyle: 'margin: 10px 0 0 30px;',
        defaults: {
            allowBlank: false,
            msgTarget: 'side',
            labelWidth: 100,
            layout:'fit'
        },
        border: false,
        defaultType:'textfield',
        activeItem:0,
        deferredRender:false,
        items: [
        	{
		        xtype: 'box',
		        width: 24,
		        autoEl: { tag:'div'}
	        },{
        	    xtype : 'image',
        	    src : 'resources/account_demo.png',
        	    mode : 'image'
        	},{
        		xtype: 'box',
	            height: 24,
	            autoEl: { tag:'div'}
	        },{
	        	xtype: 'button',
	        	text: ' Load ',
	        	id: 'loadbutton',
                handler:function(){
                	// when the button is clicked, load all the accounts
                	connectToServlet("AAAA")
                }
            },gridpanel,{
            	xtype: 'box',
            	height: 24,
            	autoEl: { tag:'div'}
            },{
            	xtype:'fieldset',
            	id:'jsondatafieldset',
            	checkboxToggle:false,
            	collapsible: true,
            	hidden:true,
            	title: 'Debug Information',
            	defaultType: 'textfield',   
            	layout: 'anchor',
            	collapsed: true,
            	fieldDefaults: { 
            		msgTarget: 'side',
            		labelWidth: 75,
            	},
            	items :[
            		{
            			xtype: 'textarea',
            			fieldLabel: 'JSON Data',
            			id:'jsondata',
            			grow: false,
            			width: '1024px',
            			height: 500,
            			scrollable:true,
            			cls: 'text-wrapper',
            			value: '',
            			anchor:'100%'
            		}
            	]
            }
        ],
        renderTo: 'account-div'
    });
    
    // create the panel for the popup window that shows account details
    frpanel = new Ext.TabPanel({
        id: 'frpanel',
        width: 500,
        height: 470,
        frame:true,
        defaults: {
            allowBlank: false,
            msgTarget: 'side',
            labelWidth: 100,
            anchor: '90%'
        },
        layoutOnTabChange: true,
        border: false,
        defaultType:'textfield',
        activeItem:0,   
        deferredRender:false,
        items: [       
        	{
                
	            title: 'Details',
	            xtype: 'form',
	            msgTarget : 'side',
	            layout: 'anchor',
	            anchor: '100%',
	            fieldDefaults: { 
	            	msgTarget: 'side',
	            	labelWidth: 75
	            },
	            defaultType:'textfield',
	            items: [
                	{
                        xtype: 'box',
                        height: 12,
                        autoEl: { tag:'div'}
                    },
                	{
                        xtype:'fieldset',
                        checkboxToggle:false,
                        collapsible: true,
                        title: 'User Information',
                        defaultType: 'textfield',   
                        layout: 'anchor',
                        fieldDefaults: { 
                        	msgTarget: 'side',
                        	labelWidth: 75
                        },
                        items :[
                	
                	{
                    xtype: 'box',
                    height: 12,
                    
                    autoEl: { tag:'div'}
                  },{
                	xtype: 'textfield',
                	id : 'det_first',
                	name : 'det_first',
                	fieldLabel: 'First Name',
                	readOnly: true
                  },{
                	xtype: 'textfield',
                	id : 'det_last',
                	name : 'det_last',
                	fieldLabel: 'Last Name',
                	readOnly: true
                  },{
                	xtype: 'textfield',
                	id : 'det_addr',
                	name : 'det_addr',
                	fieldLabel: 'Address',
                	anchor: '90%',
                	readOnly: true
                  },{
                	xtype: 'textfield',
                	id : 'det_tel',
                	name : 'det_tel',
                	fieldLabel: 'Telephone',
                	readOnly: true
                  }]
                	},{
                        xtype:'fieldset',
                        checkboxToggle:false,
                        collapsible: true,
                        collapsed:true,
                        title: 'Financial Information',
                        defaultType: 'textfield',   
                        layout: 'anchor',
                        fieldDefaults: { 
                        	msgTarget: 'side',
                        	labelWidth: 75
                        },
                        items :[
                	
                	{
                    xtype: 'box',
                    height: 12,
                    
                    autoEl: { tag:'div'}
                  },{
                	xtype: 'textfield',
                	id : 'det_cardcount',
                	name : 'det_cardcount',
                	fieldLabel: 'Number of cards',
                	readOnly: true
                  },
                  {
                  	xtype: 'textfield',
                  	id : 'det_limit',
                  	name : 'det_limit',
                  	fieldLabel: 'Charge Limit',
                  	readOnly: true
                    },{
                	xtype: 'textfield',
                	id : 'det_code',
                	name : 'det_code',
                	fieldLabel: 'Card Code',
                	readOnly: true
                  },{
                	xtype: 'textfield',
                	id : 'det_issued',
                	name : 'det_issued',
                	fieldLabel: 'Issued',
                	readOnly: true
                  },{
                	xtype: 'textfield',
                	id : 'det_approved',
                	name : 'det_approved',
                	fieldLabel: 'Approved By',
                	readOnly: true
                  }]
                	}
                
                  ]
        	},{
                    
                    title: 'Location',
                    xtype: 'gmappanel',
                    id:'gmap',
                    name:'gmap',
                    zoomLevel: 14,
                    gmapType: 'map',
                    minGeoAccuracy: 'APPROXIMATE',
                    mapConfOpts: ['enableScrollWheelZoom','enableDoubleClickZoom','enableDragging'],
                    mapControls: ['GSmallMapControl','GMapTypeControl'],
                    setCenter: {
                        lat: 39.26940,
                        lng: -76.64323
                    },
                    
                    center: {
                        geoCodeAddr: '1600 Amphitheatre Parkway, mountain view,ca',
                        marker: {title: 'Google'}
                    },
                    listeners: {
                    	'mapready': {
                    			fn: function() {
                    				addr= Ext.getCmp('det_addr').getValue();
                    				gMapReady = true;
                    				this.geoCodeLookup(addr,{ title: addr},true, true, undefined);
                              		
                              		
                    			}
                    	},
                    	'show': {
                			fn: function() {
                				if (gMapReady) {
    								addr= Ext.getCmp('det_addr').getValue();
    								this.geoCodeLookup(addr,{ title: addr},true, true, undefined);
                          		}
                          		
                				
                			}
                	}
                    }
                    }
               ]
    });
    
    // create the window that holds the popup information about a specific account
    frwin = Ext.create('widget.window',{
    	layout:'fit',
        width:500,
        id: 'frieghtwindow',
        height:450,
        closable: true,
        resizable: false,
        title: 'Customer Information',
        border: false,
        modal: true,
        closeAction: 'hide',
        items: [frpanel]
        });
});
