      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This program requires the Elastic Transaction Platform.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. moutput.
      
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       01 RESP-CODE PIC 9(4).
       
           COPY "minput.cpy".
      
      * begin mortgage variables
      * form variables       
      * 0..11
       01 STARTM PIC 999.
       01 PRICE PIC 9(14)v9(2).
       01 DPAYMENT PIC 9(14)v9(2).
      
       01 INTEREST      PIC S9(6)V9(11).
       01 IR            PIC S9(6)V9(11).
       01 INTEREST-RATE PIC S9(6)V9(11). | IR / 12
      
       01 VAR-TIME PIC 9(9).
       01 VAR-YEARS PIC 9(9).
       01 VAR-MONTH PIC 9(9).    | VAR-YEARS * 12
       01 NEG-MONTH PIC S9(9).
      
       01 MONTHPAY PIC 9(9)V9(2).
       01 STARTYEAR PIC 9999.
       
       01 NAME-OF-MONTH PIC X(12).
       
       01 HOUSE-PRICE PIC 9(14)v9(2).
       
       01 VAR-BOTTOM PIC S9(9)V9(9).
       01 VAR-TOP PIC S9(9)V9(9).
       01 VAR-MID PIC S9(9)V9(9).
       01 Y PIC 9(9).
       01 PRINCIPAL PIC S9(9)V9(2).
       01 VAR-YEAR PIC 9(4).
       01 NUM-YEARS PIC 9(9)v9(2).
       
       01 VAR-TIME-SHOW PIC ZZZ9.
       01 INTEREST-RATE-SHOW PIC ZZ9.999.
       01 INTEREST-RATE-CALC PIC 999V999.
       01 INTEREST-SHOW PIC $$$$,$$$,$$$.99.
       01 PRINCIPAL-SHOW PIC $$$$,$$$,$$$.99.
       01 MONTHPAY-SHOW PIC $$$$,$$$,$$$.99.
       01 PRICE-SHOW PIC $$$$,$$$,$$$.99.
       01 DPAYMENT-SHOW PIC $$$$,$$$,$$$.99.
       01 STARTM-SHOW PIC X(12).
       
      * end mortgage variables
      
      * begin snooper variables; these find HTTP values
       77 requesttype pic 9(5).
      
       77 httpmethod pic x(40).
       77 methodlength pic 9(5) value 40.
      
       77 httpversion pic x(40).
       77 versionlen pic 9(5) value 40.
      
       77 path pic x(40).
       77 pathlength pic 9(5) value 40.
      
       77 authtype pic x(40).
       77 authlength pic 9(5) value 40.
      
       77 contextpath pic x(40).
       77 contextpathlength pic 9(5) value 40.
      
       77 pathtranslated pic x(40).
       77 pathtranslatedlength pic 9(5) value 40.
      
       77 querystring pic x(400).
       77 querystringlength pic 9(5) value 400.
      
       77 remoteuser pic x(40).
       77 remoteuserlength pic 9(5) value 40.
      
       77 requestedsessionid pic x(400).
       77 requestedsessionidlength pic 9(5) value 400.
      
       77 requesturi pic x(80).
       77 requesturilength pic 9(5) value 80.
      
       77 requesturl pic x(80).
       77 requesturllength pic 9(5) value 80.
      
       77 servletpath pic x(80).
       77 servletpathlength pic 9(5) value 80.
      
       77 characterencoding pic x(80).
       77 characterencodinglength pic 9(5) value 80.
      
       77 contentlength pic 9(5).
       
       77 contenttype pic x(80).
       77 contenttypelength pic 9(5) value 80.
      
       77 localetext pic x(80).
       77 localetextlength pic 9(5) value 80.
      
       77 protocol pic x(80).
       77 protocollength pic 9(5) value 80.
      
       77 remoteaddr pic x(80).
       77 remoteaddrlength pic 9(5) value 80.
      
       77 remotehost pic x(80).
       77 remotehostlength pic 9(5) value 80.
      
       77 scheme pic x(80).
       77 schemelength pic 9(5) value 80.
      
       77 servername pic x(80).
       77 servernamelength pic 9(5) value 80.
      
       77 serverport pic 9(5).
      
       77 secure-status pic 9(5).
      
       77 httpheader pic x(80).
       77 namelength pic 9(5).
      
       77 httpvalue pic x(400).
       77 httpvaluelength pic 9(5).
      
       77 resp-value pic s9(5).
       77 counter pic 9999.
      
       77 comment pic x(80).
       77 commentlength pic 9999.
      
       77 domain pic x(80).
       77 domainlength pic 9999.
      
       77 maxage pic s9(18).
      
       77 version pic s9(18).
      
       77 receive-ptr pointer.
      * end snooper variables
      
      
       PROCEDURE DIVISION.
       MAIN-PARAGRAPH.
       
           IF EIBCALEN = 0 THEN
               PERFORM FIRST-TIME
           ELSE
               PERFORM ADDITIONAL-TIMES
           END-IF
           
           PERFORM COMPUTE-VALUES
           PERFORM OUTPUT-TABLE
           PERFORM SNOOPER
           
           EXEC CICS
               RETURN
           END-EXEC
           .
      
       ADDITIONAL-TIMES.
           PERFORM FIRST-TIME
           .
           
      * receive the input data from the map 
       FIRST-TIME.
           EXEC CICS
               RECEIVE MAP('minput')
                       RESP(RESP-CODE)
           END-EXEC
           .
            
           MOVE MONTHI TO STARTM
           SUBTRACT 1 FROM STARTM
           
           MOVE YEARI TO STARTYEAR
           MOVE PRICEI TO PRICE
           MOVE PRICE TO HOUSE-PRICE
           MOVE DPAYI TO DPAYMENT
           MOVE INTRESTI TO INTEREST
      * accept interest in either .0507 or 5.07 format
           IF INTEREST > 1.0 THEN
               DIVIDE INTEREST BY 100 GIVING INTEREST
           END-IF
           MOVE INTEREST TO IR
           MOVE YEARSI TO VAR-TIME
           MOVE VAR-TIME TO VAR-YEARS
           
           SUBTRACT DPAYMENT FROM HOUSE-PRICE
           MULTIPLY VAR-YEARS BY 12 GIVING VAR-MONTH
           DIVIDE IR BY 12 GIVING INTEREST-RATE ROUNDED
           .
           
       COMPUTE-VALUES.
       
           MULTIPLY VAR-MONTH BY -1 GIVING NEG-MONTH
           COMPUTE VAR-BOTTOM ROUNDED 
               = 1 - (INTEREST-RATE + 1) ** (NEG-MONTH)
           MOVE INTEREST-RATE TO VAR-TOP
           DIVIDE VAR-TOP BY VAR-BOTTOM GIVING VAR-MID ROUNDED
           
           MULTIPLY HOUSE-PRICE BY VAR-MID GIVING MONTHPAY
      
      * Subtract one month's principal initially
           ADD 1 TO STARTM
           IF STARTM > 11 THEN
               MOVE 0 TO STARTM
               ADD 1 TO VAR-YEAR
           END-IF
           .
      
       OUTPUT-TABLE.
           EXEC CICS WEB SEND 
               HTML('<h1>Elastic Transaction Platform</h1><br>')
           END-EXEC
           
           EXEC CICS WEB SEND 
               HTML('<h2>Mortgage Amortization</h2><p>')
           END-EXEC
           
           MOVE MONTHPAY TO MONTHPAY-SHOW
           
           EXEC CICS WEB SEND HTML('<b>Monthly payments:</b> ') END-EXEC
           EXEC CICS WEB SEND HTML(MONTHPAY-SHOW) END-EXEC
           EXEC CICS WEB SEND HTML('<br>') END-EXEC
           
           MOVE PRICE TO PRICE-SHOW
                      
           EXEC CICS WEB SEND
               HTML('<b>Amount of house:</b> ')
           END-EXEC
           EXEC CICS WEB SEND
               HTML(PRICE-SHOW)
           END-EXEC
           EXEC CICS WEB SEND
               HTML('<br>')
           END-EXEC
           
           MOVE DPAYMENT TO DPAYMENT-SHOW
           
           EXEC CICS WEB SEND
               HTML('<b>Amount of down payment:</b> ')
           END-EXEC
           EXEC CICS WEB SEND
               HTML(DPAYMENT-SHOW)
           END-EXEC
           EXEC CICS WEB SEND
               HTML('<br>')
           END-EXEC
           
           MULTIPLY INTEREST BY 100.00 GIVING INTEREST-RATE-CALC
           MOVE INTEREST-RATE-CALC TO INTEREST-RATE-SHOW
           
           EXEC CICS WEB SEND
               HTML('<b>Interest rate:</b> ')
           END-EXEC
           EXEC CICS WEB SEND
               HTML(INTEREST-RATE-SHOW)
           END-EXEC
           EXEC CICS WEB SEND
               HTML('<br>')
           END-EXEC
           
           EXEC CICS WEB SEND
               HTML('<b>Length of loan in years:</b> ')
           END-EXEC
           MOVE VAR-TIME TO VAR-TIME-SHOW
           EXEC CICS WEB SEND
               HTML(VAR-TIME-SHOW)
           END-EXEC
           EXEC CICS WEB SEND
               HTML('<p>')
           END-EXEC
           
           MOVE STARTYEAR TO VAR-YEAR
           
           EXEC CICS WEB SEND
               HTML('<table border=1 align=left>') 
           END-EXEC
           
           EXEC CICS WEB SEND
               HTML('<tr>')
           END-EXEC
      
           EXEC CICS WEB SEND
               HTML('<th width=150><b>Month/Year</b></th>')
           END-EXEC
               
           EXEC CICS WEB SEND
               HTML('<th width=150><b>Interest</b></th>')
           END-EXEC
               
           EXEC CICS WEB SEND
               HTML('<th width=150><b>Principal</b></th>')
           END-EXEC
           
           EXEC CICS WEB SEND
               HTML('</tr>')
           END-EXEC
      
           IF VAR-MONTH > 1000 THEN
               EXEC CICS WEB SEND
                   HTML('<i>Too many months!</i>')
               END-EXEC
               EXEC CICS RETURN END-EXEC
           END-IF
      
           PERFORM VARYING Y FROM 1 BY 1 UNTIL Y > VAR-MONTH
      * compute the interest for the month as the price of the house
      * remaining by the interest rate
               MULTIPLY HOUSE-PRICE BY INTEREST-RATE GIVING INTEREST
      * the principal paid is the monthly payment minus the interest
               SUBTRACT INTEREST FROM MONTHPAY GIVING PRINCIPAL
      * the house is cheaper by the amount of the principal
               SUBTRACT PRINCIPAL FROM HOUSE-PRICE
      * track the month number
               IF STARTM > 11 THEN
                   MOVE 0 TO STARTM
                   ADD 1 TO VAR-YEAR
               END-IF
      
      * display the interest and principal           
               MOVE INTEREST TO INTEREST-SHOW
               MOVE PRINCIPAL TO PRINCIPAL-SHOW
               
               MOVE "unknown" TO STARTM-SHOW
           
               EVALUATE STARTM
                   WHEN 0 MOVE "January" TO STARTM-SHOW
                   WHEN 1 MOVE "February" TO STARTM-SHOW
                   WHEN 2 MOVE "March" TO STARTM-SHOW
                   WHEN 3 MOVE "April" TO STARTM-SHOW
                   WHEN 4 MOVE "May" TO STARTM-SHOW
                   WHEN 5 MOVE "June" TO STARTM-SHOW
                   WHEN 6 MOVE "July" TO STARTM-SHOW
                   WHEN 7 MOVE "August" TO STARTM-SHOW
                   WHEN 8 MOVE "September" TO STARTM-SHOW
                   WHEN 9 MOVE "October" TO STARTM-SHOW
                   WHEN 10 MOVE "November" TO STARTM-SHOW
                   WHEN 11 MOVE "December" TO STARTM-SHOW
                   WHEN OTHER MOVE SPACES TO STARTM-SHOW
               END-EVALUATE
               
               EXEC CICS WEB SEND
                   HTML('<tr><td width=150>')
               END-EXEC
               EXEC CICS WEB SEND
                   HTML(STARTM-SHOW)
               END-EXEC
               EXEC CICS WEB SEND
                   HTML(' ')
               END-EXEC
               EXEC CICS WEB SEND
                   HTML(VAR-YEAR)
               END-EXEC
               EXEC CICS WEB SEND
                   HTML('</td><td width=150>')
               END-EXEC
               EXEC CICS WEB SEND
                   HTML(INTEREST-SHOW)
               END-EXEC
               EXEC CICS WEB SEND
                   HTML('</td><td width=150>')
               END-EXEC
               EXEC CICS WEB SEND
                   HTML(PRINCIPAL-SHOW)
               END-EXEC
      
               EXEC CICS WEB SEND
                   HTML('</td></tr>')
               END-EXEC
               
               ADD 1 TO STARTM
           END-PERFORM
      
           EXEC CICS WEB SEND
               HTML('</table>')
           END-EXEC
      
           EXEC CICS WEB SEND
               HTML('<p>')
           END-EXEC
           .
       SNOOPER.
           move 40 to methodlength
           move 40 to versionlen
           move 40 to pathlength
           move 40 to authlength 
           move 40 to contextpathlength
           move 40 to pathtranslatedlength 
           move 400 to querystringlength
           move 40 to remoteuserlength
           move 400 to requestedsessionidlength
           move 80 to requesturilength
           move 80 to requesturllength
           move 80 to servletpathlength
           move 80 to characterencodinglength
           move 80 to contenttypelength
           move 80 to localetextlength
           move 80 to protocollength 
           move 80 to remoteaddrlength
           move 80 to remotehostlength
           move 80 to schemelength 
           move 80 to servernamelength
      
           exec cics web extract
               requesttype(requesttype)
               httpmethod(httpmethod) methodlength(methodlength)
               httpversion(httpversion) versionlen(versionlen)
               path(path) pathlength(pathlength)
               authtype(authtype) authlength(authlength)
               contextpath(contextpath)
               contextpathlength(contextpathlength)
               pathtranslated(pathtranslated)
               pathtranslatedlength(pathtranslatedlength)
               querystring(querystring)
               querystringlength(querystringlength)
               remoteuser(remoteuser) remoteuserlength(remoteuserlength)
               requestedsessionid(requestedsessionid)
               requestedsessionidlength(requestedsessionidlength)
               requesturi(requesturi) requesturilength(requesturilength)
               requesturl(requesturl) requesturllength(requesturllength)
               servletpath(servletpath)
               servletpathlength(servletpathlength)
               characterencoding(characterencoding)
               characterencodinglength(characterencodinglength)
               contentlength(contentlength)
               contenttype(contenttype)
               contenttypelength(contenttypelength)
               locale(localetext) localelength(localetextlength)
               protocol(protocol) protocollength(protocollength)
               remoteaddr(remoteaddr) remoteaddrlength(remoteaddrlength)
               remotehost(remotehost) remotehostlength(remotehostlength)
               scheme(scheme) schemelength(schemelength)
               servername(servername) servernamelength(servernamelength)
               serverport(serverport)
               secure(secure-status)
           end-exec
           
           exec cics web send 
               html('<p><b><i><a href="'
                    requesturl 
                    '">Click here to continue</a></i></b><p>'
                    )
           end-exec
           .
           
       output-snooper-info.
      
           exec cics web send 
               html('<p><b>HTML inspection:</b><p>') 
           end-exec
      
           evaluate requesttype
               when dfhvalue(HTTP)
                   exec cics web send textline("HTTP") end-exec
               when dfhvalue(NONHTTP)
                   exec cics web send textline("NONHTTP") end-exec
               when other
                   exec cics web send 
                       textline("Unknown whether HTTP or NONHTTP") 
                   end-exec
           end-evaluate
      
           evaluate secure-status
               when dfhvalue(SSL)
                   exec cics web send textline("SSL") end-exec
               when dfhvalue(NOSSL)
                   exec cics web send textline("NOSSL") end-exec
               when other
                   exec cics web send 
                       textline("Unknown whether SSL or NOSSL") 
                   end-exec
           end-evaluate
      
           exec cics web send 
               textline("HTTP METHOD: " httpmethod ":" methodlength) 
           end-exec
           exec cics web send
               textline("HTTP VERSION: " httpversion ":" versionlen) 
           end-exec
           exec cics web send
               textline("PATH: " path ":" pathlength) 
           end-exec
           exec cics web send
               textline("AUTH: " authtype ":" authlength) 
           end-exec
           exec cics web send 
               textline("CONTEXT PATH: " contextpath ":" 
               contextpathlength) 
           end-exec
           exec cics web send 
               textline("PATH TRANSLATED: " pathtranslated ":" 
               pathtranslatedlength) 
           end-exec
           exec cics web send 
               textline("QUERY STRING: " querystring ":" 
               querystringlength) 
           end-exec
           exec cics web send 
               textline("REMOTE USER: " remoteuser ":" remoteuserlength) 
           end-exec
           exec cics web send 
               textline("REQUESTED SESSION ID: " requestedsessionid ":" 
               requestedsessionidlength) 
           end-exec
           exec cics web send 
               textline("REQUEST URI: " requesturi ":" requesturilength) 
           end-exec
           exec cics web send 
               textline("REQUEST URL: " requesturl ":" requesturllength) 
           end-exec
           exec cics web send 
               textline("SERVLET PATH: " servletpath ":" 
               servletpathlength) 
           end-exec
           exec cics web send 
               textline("CHARACTER ENCODING: " characterencoding ":" 
               characterencodinglength)
           end-exec
           exec cics web send 
               textline("CONTENT LENGTH: " contentlength)
           end-exec
           exec cics web send 
               textline("CONTENT TYPE: " contenttype ":" 
               contenttypelength)
           end-exec
           exec cics web send 
               textline("LOCALE: " localetext ":" localetextlength)
           end-exec
           exec cics web send 
               textline("PROTOCOL: " protocol ":" protocollength)
           end-exec
           exec cics web send 
               textline("REMOTE ADDR: " remoteaddr ":" remoteaddrlength)
           end-exec
           exec cics web send 
               textline("REMOTE HOST: " remotehost ":" remotehostlength)
           end-exec
           exec cics web send 
               textline("SCHEME: " scheme ":" schemelength)
           end-exec
           exec cics web send 
               textline("SERVER NAME: " servername ":" servernamelength)
           end-exec
           exec cics web send 
               textline("SERVER PORT: " serverport)
           end-exec
           .
           
