*
* GFXSAMPLE
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in 
* conjunction with the Elastic COBOL product.
*
* This program demonstrates a variety of graphical components:
*
*	bar		A graphical horizontal or vertical bar.
*	frame		A frame around a group of components.
*	label		A text label.
*	push-button	A button the user can push.
*	list-box	A list of choices for the user.
*	entry-field	A textfield for user text entry.
*	check-box	A single checkable box, representing a boolean value.
*	radio-button	A mutually exclusive, selectable button, grouped.
*	scroll-bar	A scroll-bar directly controllable as a component.
*	slider		A slider with tick marks.
*	bitmap		A bitmap image to be displayed.
*	menu		A menu-bar at the top of the window/screen.
*	status-bar	A status-bar at the bottom of the screen.
*	tree-view	A hierarchical tree of information.
*
* This program is not meant to be aesthetic, but rather to demonstrate
* a variety of graphical components available for use in the graphical
* screen section.
*
id division.
program-id. gfxsample.

data division.

working-storage section.

* Specifying special-names crt status here is the same as specifying
* a crt status clause in the special-names paragraph refereing
* the same variable.  Specifying a numeric item will yield the
* termination values in the variable; this is generally easier
* to manage that the more traditional pic x approach.  (If specified
* as a pic x, Elastic COBOL does use the more traditional crt status as
* well.)

01 key-status is special-names crt status pic 9(4) value zero.
    88 exit-button-pressed value 13.

* These are some variables which hold return data from components.

01 list-data pic x(10) value spaces.    
01 entry-data pic x(14).
01 check-value pic 9 value 0.
01 radio-value pic 9 value 0.
01 combo-value pic x(12) value "January".
01 scrollbar-value pic 999 value 0.
01 slider-value pic 999 value 0.

* These are used for the status-panel.

01 running pic x(4) value "RUN ".
01 counter pic 9(9) value 0.

* These holds references to the controls themselves.
01 the-status-bar handle of status-bar.

* Any numeric type will do here so long as it has enough range
* to hold the generated numbers.  These reference tree nodes
* in the tree-view.

01 parent-1 pic 999 comp.
01 parent-2 pic 999 comp.

screen section.

01 main-screen.

*  A nice graphical border to the window; the title isn't used.

    05 the-menu menu title "Menu Bar".

*  Bottom    	

    05 bar line 25 col 1 size 79.6 width = 5, color 4,
        shading = (-1, 1, 0, 0, -2). 
	
*  Left

    05 bar line 1 col 1 lines 24, width = 5, color 4,
        shading = (-1, 1, 0, 0, -2)
	trailing-shift = (3, 2, 1).
	
	
*  Top

    05 bar line 1 col 1 size 79.6 width = 5, color 4,
        shading = (-1, 1, 0, 0, -2)
	position-shift = -1
	leading-shift = (0, 1, 2, 3, 4).
	
*  Right
    05 bar line 1 col 80 lines 24 width = 5, color 4,
        shading = (-1, 1, 0, 0, -2)
	leading-shift = (4, 3, 2, 1, 0)
	trailing-shift = (0, 1, 2, 3, 4).

*  Frame around Description Label

    05 frame "Description" line 2 column 2 lines 6 size 22 cells
       engraved.

*  Description Label

    05 label "This program demonstrates the various graphical handle components."
        line 3 column 3 lines 4 size 20 cells
	background-color 9 foreground-color 14.

*  Push-Button to Exit (ok-button makes the termination value 13)

    05 push-button line 23 column 70 ok-button title "E&xit".
    
*  List-Box

    05 the-list-box list-box using list-data
       line 9 column 2 lines 5 size 22 cells
       title "Fruit".

*  Entry-Field

    05 label "Telephone:" line 15 column 2.
    05 the-entry-field entry-field using entry-data
       mask-value "(###) ###-####"
       title "Phone Number".
       
*  Check-box

    05 check-box "Use radio-buttons" using check-value
       line 2 column 30.

*  Radio-Buttons (usually in a frame, but not required)

    05 frame "Where?" line 4 column 29 lines 6 size 10 engraved.
    
    05 radio-button "Here" using radio-value group=1 group-value = 1
       line 5 column 30.
    05 radio-button "There" using radio-value group=1 group-value = 2
       line 6.5 column 30.
    05 radio-button "Other" using radio-value group=1 group-value = 3
       line 8 column 30.

*  Combo-Box

    05 the-combo-box combo-box using combo-value
       line 11 column 30 lines 5 size 22 cells
       title "Month".

*  Scroll-Bar component; generally used as part of components, not for users

    05 scroll-bar 
       line 13 column 30 lines 2 size 22 cells
       min-val = 0 max-val = 100
       horizontal
       using scrollbar-value.

*  Slider component, like a scroll-bar, but better suited for end-users.
    
    05 slider line 15 column 30 lines 4 size 22 cells
        min-val = 0 max-val = 100 major-tick = 25 minor-tick = 10
	horizontal
	paint-ticks = 25
	paint-labels = 25
	snap-to-ticks = 1
	using slider-value.

*  Push-Button

    05 push-button "Push Me!" background-color = 5
        column 30 line 20
        termination-value = 33
	.

*  Bitmap lines and size are in pixels.
*
*  A bitmap may refer to a jpg, gif, bmp, ico, or in JDK 1.3, png.
	
    05 bitmap bitmap-value = "heirloom.png"
       line 2 column 60 lines 48 size 48.

* Tree-View

    05 the-tree tree-view
       line 7 column 60 lines 10 size 18
       buttons show-lines lines-at-root 3-d.

procedure division.
main-paragraph.

*   Add items to the list-box; by default, they're added in sorted order
    
    modify the-list-box 
        item-to-add=( "Apples", "Oranges", "Pears", "Limes", "Kiwi",
	    "Apricot", "Tangerine", "Tangelo", "Cherry")

*   The 'unsorted' property was applied so the Months would be in order;
*   The 'unsorted' property must be applied BEFORE any items are added;
*   otherwise, the items will be in sorted order.  The properties in
*   the screen section are applied at time of DISPLAY; these properties
*   in a MODIFY are applied immediately, so the 'unsorted' must be 
*   applied here.

    modify the-combo-box unsorted
        item-to-add=( "January", "February", "March", "April",
        "May", "June", "July", "August",
	"September", "October", "November", "December")

*   Create the menu; any graphics items with item-to-add styles
*   for adding multiple items should generally be initialized
*   in the procedure division if there is any possibility whatsoever
*   that the display would be redone.
*
*   Note that the creation of the menu is very hierarchical, and how
*   it so closely resembles the displayed menu structure.
*
*   The ampersands mark the hotkey.  The termination-value is set
*   individually for each separate menu item.  Menus may be nested.
*
*   These menus don't actually do anything in this demo except
*   the exit menu item.

    modify the-menu	
       begin-menu = "&File"
           item-to-add = "&Open"       termination-value = 1
	   item-to-add = "&Save"       termination-value = 2
	   item-to-add = "Save &As..." termination-value = 3
	   separator
	   item-to-add = "E&xit"       termination-value = 13
       end-menu
       begin-menu = "&Edit"            termination-value = 4
           item-to-add = "Cu&t"        termination-value = 5 
                                       accelerator = "control X"
	   item-to-add = "&Copy"       termination-value = 6 
                                       accelerator = "control C"
	   item-to-add = "&Paste"      termination-value = 7 
                                       accelerator = "control V"
       end-menu
       .
    
*   Create the main application window.

    display standard graphical window, background-low

*   Display the status-bar, saving its reference in the-status-bar

    display status-bar handle in the-status-bar
        panel-widths ( 20, 10, 20 )
        panel-style ( 1, 2, 1 ) | lowered, raised, lowered, 0 is flat
        panel-text ( "Status Bar", running, counter)
	
*   Add items to the tree

    modify the-tree
        item-to-add = "Parent 1" giving parent-1,
          parent = parent-1
          item-to-add = "1.First Child"
          item-to-add = "1.Second Child"
          item-to-add = "1.Third Child"
        parent = 0
          item-to-add = "Parent 2" giving parent-2
          parent = parent-2
          item-to-add = "2.First Child"
          item-to-add = "2.Second Child"
          item-to-add = "2.Third Child"

*   Continue looping until the exit button (or exit menu with same code) 
*   is pressed.

    perform until exit-button-pressed
    
        add 1 to counter

*       Modify the previously displayed status-bar, setting its counter field
	
	modify the-status-bar panel-index = 3 panel-text = counter
	
        display main-screen
        accept main-screen
	
	display "list           : " list-data upon sysout
	display "entry          : " entry-data upon sysout
	display "check-value    : " check-value upon sysout
	display "radio-value    : " radio-value upon sysout
	display "combo-value    : " combo-value upon sysout
	display "scrollbar-value: " scrollbar-value upon sysout
	display "slider-value   : " slider-value upon sysout
	
	if key-status = 33 then
	    display message box "The button was pushed." type-ok
	end-if
    
    end-perform
    
*   Force all graphics threads to stop; a 'stop run' is insufficient
*   as it eliminates only Cobol threads; to COMPLETELY exit the application
*   without requiring the user to click the close button, a 'stop all run'
*   should be used.

    display message box "Graphical Sample is Done" type-ok.

    stop all run
    
    .
    

