*
* GFXSCREENSECTION
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in 
* conjunction with the Elastic COBOL product.
*
* This program demonstrates some of the graphical syntax supported
* by Elastic COBOL.  This syntax is suitable for bringing pre-existing
* screen section and random display/accept syntax into graphics.
*
* All notation is done in character cells; fractional character cells
* are accepted, but discouraged.
*
identification division.
program-id. gfxscreensection.

data division.
working-storage section.

01 my-data pic x(20).

screen section.

01 screen-1.

* Specify a label with implicitly defined text at a line and column
    05 label "Enter 20 cols of data:" line 4 column 15.

* Allow the entry-field to immediately follow the label
    05 my-entry-field entry-field using my-data.

* Specify a push-button to act like a return-key; give it a larger
* size (width) and lines (height)

    05 push-button "Enter Data" line 8 column 25 size = 10 lines = 2
       termination-value = 13.

procedure division.
main-par.

*   Create the initial window as black on gray (standard as opposed to initial)

    display standard window lines = 15 size = 60

*   Display some plain text; text and graphics may be mixed together.
*   Mouse selection of text input fields are now supported.
    
    display "Traditional Text Output on Line 1"
    
*   Display and accept the screen    
    display screen-1
    accept screen-1
    
*   Hide the components of screen-1 (not necessary in this example)
*   hide screen screen-1

*   Display a dialog to the user with the input data    
    display message box title "You Entered" value my-data type-ok
    
*   Redisplay the components of screen-1        
*   show screen screen-1

*   Completely eliminate all memory and visibility of screen-1       
*   destroy screen-1

*   Force the program to exit
    stop all run    
    .
     
