*
* MY-CLASS
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in 
* conjunction with the Elastic COBOL product.
*
id division.
class-id. My_Class.

data division.
shared-storage section.
01 share-1 pic x(10) value spaces.

working-storage section.
01 work-1 pic x(10) value spaces.

local-storage section.
01 local-1 pic x(10) value spaces.

| Method Definition

    id division.
    method-id. One.
    
    data division.
    working-storage section.
    01 counter-w pic 999 value 0.
    
    local-storage section.
    01 counter-l pic 999 value 0.
    
    procedure division.
    main-par.
        move "s1" to share-1
        move "w1" to work-1
 	    move "l1" to local-1
	
        display "s1='" share-1 "'" upon sysout
        display "w1='" work-1 "'" upon sysout
        display "l1='" local-1 "'" upon sysout
    
        add 1 to counter-w
        add 1 to counter-l
        display "one: " counter-w ", " counter-l upon sysout
	.
    end method.
	
| Method Definition

    id division.
    method-id. Two.
    
    data division.
    working-storage section.
    01 counter-w pic 999 value 0.
    
    local-storage section.
    01 counter-l pic 999 value 0.
    
    procedure division.
    main-par.
        display "s1='" share-1 "'" upon sysout
        display "w1='" work-1 "'" upon sysout
        display "l1='" local-1 "'" upon sysout
    	
        add 1 to counter-w
        add 1 to counter-l
        display "two: " counter-w ", " counter-l upon sysout
	.
    end method.
	
| Method Definition

    id division.
    method-id. three.
    
    data division.
    working-storage section.
    01 counter-w pic 999 value 0.
    
    local-storage section.
    01 counter-l pic 999 value 0.
    
    procedure division.
    main-par.
        display "s1='" share-1 "'" upon sysout
        display "w1='" work-1 "'" upon sysout
        display "l1='" local-1 "'" upon sysout
    	
        add 1 to counter-w
        add 1 to counter-l
        display "thr: " counter-w ", " counter-l upon sysout
	.
    end method.
    
    id division.
    method-id. shortadder.
    
    data division.
    working-storage section.
    01 my-result comp-x pic x(2).
    
    linkage section.
    01 add1 comp-x pic x(2).
    01 add2 comp-x pic x(2).
    
    procedure division using by value add1 add2 giving my-result.
    main-par.
        display "s1='" share-1 "'" upon sysout
        display "w1='" work-1 "'" upon sysout
        display "l1='" local-1 "'" upon sysout
    	
        add add1 to add2 giving my-result
        goback
	.
    end	method.
    
    identification division.
    method-id. outputter.
    
    data division.
    working-storage section.
    01 gamma object reference "java.util.Vector".
    
    linkage section.
    01 alpha object reference "java.lang.String".
    01 beta object reference "java.awt.Color".
    
    procedure division using by value alpha beta giving gamma.
    main-par.
        display "s1='" share-1 "'" upon sysout
        display "w1='" work-1 "'" upon sysout
        display "l1='" local-1 "'" upon sysout
    	
        display "String =" alpha upon sysout
        display "Color=" beta upon sysout
	
        display "Constructing a new Vector" upon sysout
	
        invoke gamma giving gamma | construct a new Vector
	 
        display "Adding 10 Strings to the Vector" upon sysout
	
        perform 10 times
	        invoke gamma "addElement" using by value alpha
        end-perform
	
        display "added" upon sysout.
        goback.
    end	method.
    
    identification division.
    method-id. normal.
    
    data division.
    working-storage section.
    01 epsilon comp-x pic x(4).
    
    linkage section.
    01 alpha comp-x pic x(4).
    01 beta comp-x pic x(4).
    01 gamma comp-x pic x(4).
    
    procedure division using by reference alpha, by content beta, by value gamma
                       giving epsilon.
    main-paragraph.
        display "s1='" share-1 "'" upon sysout
        display "w1='" work-1 "'" upon sysout
        display "l1='" local-1 "'" upon sysout
	
        display "alpha:" alpha upon sysout
        display "beta :" beta upon sysout
        display "gamma:" gamma upon sysout
        move gamma to epsilon
	.		       
    end method.	
    
    id division.
    method-id. "myMixedCapsMethod".
    
    data division.
    working-storage section.
    01 local-persistent-data pic x(4) value spaces.
    
    local-storage section.
    01 local-volatile-data pic x(4) value spaces.
    
    linkage section.
    01 alpha object reference "java.lang.String".
    
    procedure division using alpha.
    main-paragraph.
        display "s1='" share-1 "'" upon sysout
        display "w1='" work-1 "'" upon sysout
        display "l1='" local-1 "'" upon sysout
    
        display "Alpha passed into myMixedCapsMethod is '" alpha "'" 
            upon sysout
    . 
    end method.	
    
end class.

