      *
      * READER
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in
      * conjunction with the Elastic COBOL product.
      *
      * Reader displays the text in a file which is assigned to
      * reader-file.  This is useful for experimentation with
      * different readable file protocols.
      *
       IDENTIFICATION DIVISION.                                        
       PROGRAM-ID.                                                     
           READER.                                                     
      
       ENVIRONMENT DIVISION.                                           
       CONFIGURATION SECTION.                                          
       INPUT-OUTPUT SECTION.                                          
       FILE-CONTROL.                                                   
           SELECT READER-FILE ASSIGN TO
               "http://www.google.com/index.html"
      *
      *        The remote file server must be started as below:
      *        "remote:127.0.0.1:readme.txt"
      *
                FILE STATUS IS FILE-STATUS
                .
      
       DATA DIVISION.                                                  
       FILE SECTION.                                                  
       FD  READER-FILE.                                              
       01  READ-REC PICTURE X.
      
       WORKING-STORAGE SECTION.
       77 FILE-STATUS PIC 99 value 0.
      
       PROCEDURE DIVISION.
       MAIN-PARAGRAPH.
      
           display "--begin--" upon sysout
           
           open input reader-file
      
           if file-status not equal to "00" then
      	       display "Cannot open, file status " file-status
      	               upon sysout
               goback
      	   end-if
           .
      
       Read-Loop.
           read reader-file
           if file-status >=10 then 
               go to reading-done
           end-if
      
      	   display read-rec upon sysout with no advancing
           go to read-loop
           .
      
       Reading-done.
      	   display "--end-- file-status=" file-status upon sysout
      	   display "" upon sysout
           close reader-file
      	   .
