      *
      * REGISTER
      *
      * Copyright (C) 2010-2023 Heirloom Computing.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in
      * conjunction with the Elastic COBOL product.
      *
      * This program accepts registration from a user via an HTML page
      * and passes the information to this program running as a servlet.
      *
      
       IDENTIFICATION DIVISION.
       PROGRAM-ID. REGISTER.
       
       ENVIRONMENT DIVISION.
       INPUT-OUTPUT SECTION.
       FILE-CONTROL.
      *
      * File to hold the data; any type of file will do.
      * Reassign to the actual location.
      *
       SELECT OPTIONAL PRINT-FILE ASSIGN TO "register.txt"
           ORGANIZATION IS RELATIVE
           FILE STATUS MYSTATUS
           .
       
       DATA DIVISION.
       FILE SECTION.
       FD PRINT-FILE.
      *
      * Data record
      *
       01 PRINT-RECORD.
           05 FIRST-NAME PIC X(12).
           05 MIDDLE-INITIAL PIC X.
           05 LAST-NAME PIC X(18).
       
           05 COMPANY PIC X(30).
           05 DEPARTMENT PIC X(30).
           05 STREET PIC X(30).
       
           05 CITY PIC X(13).
           05 STATE PIC X(2).
           05 ZIP PIC X(10).
       
           05 COUNTRY PIC X(30).
           05 TELEPHONE PIC X(16).
           05 FAX PIC X(16).
           05 EMAIL PIC X(30).
           05 SERIAL PIC X(25).
       
           05 PRODUCT PIC X(25).
           05 PLATFORM PIC X(25).
           05 OWNER PIC X(25).
       
           05 COMMENT PIC X(50).
       
       WORKING-STORAGE SECTION.
       
       01 SOMEONE PIC X(20) VALUE "Heirloom".
       
       01 WORK-RECORD.
           05 MISSING-ITEMS PIC 99.
           05 MISSING-ITEM PIC X(20).
           05 MYSTATUS PIC XX.
       
           05 FIRST-NAME PIC X(12).
           05 MIDDLE-INITIAL PIC X.
           05 LAST-NAME PIC X(18).
       
           05 COMPANY PIC X(30).
           05 DEPARTMENT PIC X(30).
           05 STREET PIC X(30).
        
           05 CITY PIC X(13).
           05 STATE PIC X(2).
           05 ZIP PIC X(10).
       
           05 COUNTRY PIC X(30).
           05 TELEPHONE PIC X(16).
           05 FAX PIC X(16).
           05 EMAIL PIC X(30).
           05 SERIAL PIC X(25).
       
           05 PRODUCT PIC X(25).
           05 PLATFORM PIC X(25).
           05 OWNER PIC X(25).
        
           05 COMMENT PIC X(50).
       
       PROCEDURE DIVISION.
       MAIN-PARAGRAPH.
      *
      * Display a greeting to anyone running this servlet as an
      * application.
      *
           DISPLAY "Product Registration Servlet" UPON SYSOUT.
           DISPLAY "Copyright (C) Heirloom Computing Inc." UPON SYSOUT
           DISPLAY "All Rights Reserved." UPON SYSOUT
           DISPLAY "" UPON SYSOUT
           DISPLAY "Install this application under a web" UPON SYSOUT
           DISPLAY "application server, and load via" UPON SYSOUT
           DISPLAY "http://localhost:8080/register/register.html"
                UPON SYSOUT
           STOP RUN
           .
      
      *
      * Servlet code begins here
      *
      
       SERVLET-POST.
      
           PERFORM READ-DATA
           PERFORM WRITE-DATA
           PERFORM NOTIFY-DONE
           .
      
       READ-DATA.
      *
      * Initialize the missing data to nothing.
      *
          MOVE 0 TO MISSING-ITEMS
          MOVE SPACES TO MISSING-ITEM
            
      *
      * Accept user information.
      * 
           ACCEPT FIRST-NAME OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-first"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "FIRST-NAME" TO MISSING-ITEM
           END-ACCEPT
        
           IF FIRST-NAME OF WORK-RECORD = "init" THEN
               DISPLAY "Initialized Servlet." upon sysout
               EXEC HTML
                  <HEAD><TITLE>Initialized...</TITLE></HEAD>
                  <BODY><H1>Initialization Done.</H1></BODY>
               END-EXEC
               GOBACK
           END-IF 
      
           IF FIRST-NAME OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "FIRST-NAME" TO MISSING-ITEM
           END-IF
      
           ACCEPT MIDDLE-INITIAL OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-initial"
           END-ACCEPT
        
           ACCEPT LAST-NAME OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-last"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "LAST-NAME" TO MISSING-ITEM
           END-ACCEPT
      
           IF LAST-NAME OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "LAST-NAME" TO MISSING-ITEM
           END-IF
      
           ACCEPT COMPANY OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-company"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "COMPANY" TO MISSING-ITEM
           END-ACCEPT
        
           IF COMPANY OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "COMPANY" TO MISSING-ITEM
           END-IF
      
           ACCEPT DEPARTMENT OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-department"
           END-ACCEPT
        
           ACCEPT STREET OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-street"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "STREET" TO MISSING-ITEM
           END-ACCEPT
        
           IF STREET OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "STREET" TO MISSING-ITEM
           END-IF
        
           ACCEPT CITY OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-city"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "CITY" TO MISSING-ITEM
           END-ACCEPT
        
           IF CITY OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "CITY" TO MISSING-ITEM
           END-IF
        
           ACCEPT STATE OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-state"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "STATE" TO MISSING-ITEM
           END-ACCEPT
        
           IF STATE OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "STATE" TO MISSING-ITEM
           END-IF
        
           ACCEPT ZIP OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-zip"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "ZIP" TO MISSING-ITEM
           END-ACCEPT
      
           IF ZIP OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "ZIP" TO MISSING-ITEM
           END-IF
        
           ACCEPT COUNTRY OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-country"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "COUNTRY" TO MISSING-ITEM
           END-ACCEPT
        
           IF COUNTRY OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "COUNTRY" TO MISSING-ITEM
           END-IF
        
           ACCEPT TELEPHONE OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-telephone"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "TELEPHONE" TO MISSING-ITEM
           END-ACCEPT
        
           IF TELEPHONE OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "TELEPHONE" TO MISSING-ITEM
           END-IF
        
           ACCEPT FAX OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-fax"
           END-ACCEPT
        
           ACCEPT EMAIL OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-email"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "EMAIL" TO MISSING-ITEM
           END-ACCEPT
        
           IF EMAIL OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "EMAIL" TO MISSING-ITEM
           END-IF
        
           ACCEPT SERIAL OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-serial"
           END-ACCEPT
      
           IF SERIAL OF WORK-RECORD = SPACES THEN 
               MOVE "eval" TO SERIAL OF WORK-RECORD
           END-IF
        
           ACCEPT PRODUCT OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-product"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "PRODUCT" TO MISSING-ITEM
           END-ACCEPT
        
           IF PRODUCT OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "PRODUCT" TO MISSING-ITEM
           END-IF
        
           ACCEPT PLATFORM OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-platform"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "PLATFORM" TO MISSING-ITEM
           END-ACCEPT
        
           IF PLATFORM OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "PLATFORM" TO MISSING-ITEM
           END-IF
        
           ACCEPT OWNER OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-owner"
           ON EXCEPTION
               ADD 1 TO MISSING-ITEMS
               MOVE "OWNER" TO MISSING-ITEM
           END-ACCEPT
      
           IF OWNER OF WORK-RECORD = SPACES THEN
               ADD 1 TO MISSING-ITEMS
               MOVE "OWNER" TO MISSING-ITEM
           END-IF
      
           ACCEPT COMMENT OF WORK-RECORD FROM 
               ENVIRONMENT "SERVLET-PARAMETER-comment"
           END-ACCEPT
        
           IF MISSING-ITEMS > 0 THEN
               EXEC HTML
               <HEAD>
               <TITLE>
               FORM ERROR: Missing Required Information
               </TITLE>
               </HEAD>
      
               <BODY>
               END-EXEC
                              
               PERFORM HEADER-RESPONSE
               
               EXEC HTML
               The form could not be processed because it was missing 
               <hostvar name=MISSING-ITEMS></hostvar>
               pieces of required information, including
               <hostvar name=MISSING-ITEM></hostvar>.
               <p>
               All fields in <b>bold</b> are required fields.
               Please press the <b>BACK</b> button in your browser
               to return to the prior page.
               </BODY>   
               END-EXEC
               GOBACK
           END-IF
           .
        
       WRITE-DATA.
       
           OPEN EXTEND PRINT-FILE
                 
           MOVE FIRST-NAME OF WORK-RECORD TO FIRST-NAME OF PRINT-FILE
           MOVE MIDDLE-INITIAL OF WORK-RECORD
                TO MIDDLE-INITIAL OF PRINT-FILE
           MOVE LAST-NAME OF WORK-RECORD TO LAST-NAME OF PRINT-FILE
           MOVE COMPANY OF WORK-RECORD TO COMPANY OF PRINT-FILE
           MOVE DEPARTMENT OF WORK-RECORD TO DEPARTMENT OF PRINT-FILE
           MOVE STREET OF WORK-RECORD TO STREET OF PRINT-FILE
           MOVE CITY OF WORK-RECORD TO CITY OF PRINT-FILE
           MOVE STATE OF WORK-RECORD TO STATE OF PRINT-FILE
           MOVE ZIP OF WORK-RECORD TO ZIP OF PRINT-FILE
           MOVE COUNTRY OF WORK-RECORD TO COUNTRY OF PRINT-FILE
           MOVE TELEPHONE OF WORK-RECORD TO TELEPHONE OF PRINT-FILE
           MOVE FAX OF WORK-RECORD TO FAX OF PRINT-FILE
           MOVE EMAIL OF WORK-RECORD TO EMAIL OF PRINT-FILE
           MOVE SERIAL OF WORK-RECORD TO SERIAL OF PRINT-FILE
           MOVE PRODUCT OF WORK-RECORD TO PRODUCT OF PRINT-FILE
           MOVE PLATFORM OF WORK-RECORD TO PLATFORM OF PRINT-FILE
           MOVE OWNER OF WORK-RECORD TO OWNER OF PRINT-FILE
           MOVE COMMENT OF WORK-RECORD TO COMMENT OF PRINT-FILE
      
           WRITE PRINT-RECORD
           CLOSE PRINT-FILE
           .
        
       NOTIFY-DONE.	
           EXEC HTML
           <HEAD>
           <TITLE>Product Registration Received</TITLE>
           </HEAD>
      
           <BODY>
           END-EXEC
               
           PERFORM HEADER-RESPONSE
               
           EXEC HTML
           <H1>Thank you for registering!</H1>
           <P>
           END-EXEC
           .
            
           EXEC HTML
           <p><B>Registration Information:</B><p>
           Name: <hostvar name=first-name of work-record></hostvar>
           <hostvar name=middle-initial of work-record></hostvar>
           <hostvar name=last-name of work-record></hostvar> <br>
           Company: <hostvar name=company of work-record></hostvar><br>
           Department: 
           <hostvar name=department of work-record></hostvar><br>
           Street: <hostvar name=street of work-record></hostvar><br>
           City: <hostvar name=city of work-record></hostvar><br>
           State: <hostvar name=state of work-record></hostvar><br>
           Zip: <hostvar name=zip of work-record></hostvar><br>
           Country: <hostvar name=country of work-record></hostvar><br>
           Telephone: 
           <hostvar name=telephone of work-record></hostvar><br>
           Fax: 
           <hostvar name=fax of work-record></hostvar of work-record><br>
           E-mail: <hostvar name=email of work-record></hostvar><br>
           Serial Number: 
           <hostvar name=serial of work-record></hostvar><br>
           Product: <hostvar name=product of work-record></hostvar><br>
           Platform: <hostvar name=platform of work-record></hostvar><br>
           Owner: <hostvar name=owner of work-record></hostvar><br>
           Comment: <hostvar name=comment of work-record></hostvar><br>
           <p>
           <i>
           Copyright (C) <a href="http://heirloom.cc">
           Heirloom Computing Inc.</a><br>
           All Rights Reserved.
           </i>
           </BODY>
           END-EXEC
           .

       HEADER-RESPONSE.
           EXEC HTML
               <a href="http://heirloom.cc">heirloom.cc</a> | 
               <a href="http://elasticcobol.com">elasticcobol.com</a> | 
               <a href="/register/register.cbl">register.cbl</a>
               <H1>
               <span style="color: white; background-color: grey">
               Elastic COBOL servlet response:</span>
               <p>
               Hello <span style=
               "background-color: #19c919; color: black">
               <hostvar name=SOMEONE></hostvar></span></H1>
           END-EXEC
           .
