*
* guiscreen1
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in
* conjunction with the Elastic COBOL product.
*
id division.
program-id. guiscreen1.

data division.

working-storage section.

    77 title-data pic x(4) value "Mr.".
    77 name-data pic x(20) value spaces.
    77 addr-data pic x(20) value spaces.
    77 city-data pic x(20) value spaces.
    77 state-data pic x(2) value "CA".
    77 zip-data pic 9(5) value spaces.
    77 sex-data pic x value "M".
    77 cust-data pic x value "Y".
    77 sport-data pic 9 value "1".

screen section.
01 main-screen.
    05 label-title value "Title:" line 2 column 2.
    05 ask-title line 2 column 10 using title-data.
    
    05 label-name value "Name:" line 4 column 2.
    05 ask-name line 4 column 10 using name-data.
    
    05 label-addr value "Address:" line 6 column 2.
    05 ask-addr line 6 column 10 using addr-data.
    
    05 label-city value "City:" line 8 column 2.
    05 ask-city line 8 column 10 using city-data.
    
    05 label-state value "State:" line 10 column 2.
    05 ask-state line 10 column 10 using state-data.
    
    05 label-zip value "Zip:" line 10 column 17.
    05 ask-zip line 10 column 22 using zip-data.
    
    05 label-sex value "Sex:" line 12 column 2.
    05 ask-sex line 12 column 10 using sex-data.
    
    05 label-cust value "Current Customer (Y/N): " line 14 column 2.
    05 ask-cust line 14 column 28 using cust-data.
    
    05 label-sport value "Sports" line 16 column 2.
    05 label-sport-1 value "1) Golf" line 17 column 2.
    05 label-sport-2 value "2) Bowling" line 18 column 2.
    05 label-sport-3 value "3) Hockey" line 19 column 2.
    
    05 label-sport-choice value "Sport Selection (1,2,3): " line 20 column 2.
    05 ask-sport line 20 column 28 using sport-data.

procedure division.
main-paragraph.

* Create an initial window by specifying it, rather than using default

    display standard window 
        title ="Gui Screen"
        size 60 lines 25
	foreground-color 0
	
    display main-screen
    
main-loop.    
    accept main-screen
    perform display-data
    go to main-loop
    .
display-data.
    display "title: " title-data upon sysout
    display "name: " name-data upon sysout
    display "addr: " addr-data upon sysout
    display "city: " city-data upon sysout
    display "state: " state-data upon sysout
    display "zip: " zip-data upon sysout
    display "sex: " sex-data upon sysout
    display "cust: " cust-data upon sysout
    display "sport: " sport-data upon sysout
    .
    
