*
* guiscreen4
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in
* conjunction with the Elastic COBOL product.
*
id division.
program-id. guiscreen4.

data division.

working-storage section.

    77 title-data pic x(4) value "Mr.".
    77 name-data pic x(20) value spaces.
    77 addr-data pic x(20) value spaces.
    77 city-data pic x(20) value spaces.
    77 state-data pic x(2) value "CA".
    77 zip-data pic 9(5) value spaces.
    77 sex-data pic x value "M".
    77 cust-data pic x value "Y".
    77 sport-data pic 9 value "1".
    
    77 sport-item pic x(5).

screen section.
01 main-screen.
    05 label-title label "Title:" line 2 column 2.
    05 ask-title entry-field line 2 column 10 using title-data.
    
    05 label-name label "Name:" line 4 column 2.
    05 ask-name entry-field line 4 column 10 using name-data.
    
    05 label-addr label "Address:" line 6 column 2.
    05 ask-addr entry-field line 6 column 10 using addr-data.
    
    05 label-city label "City:" line 8 column 2.
    05 ask-city entry-field line 8 column 10 using city-data.
    
    05 label-state label "State:" line 10 column 2.
    05 ask-state entry-field line 10 column 10 using state-data.
    
    05 label-zip label "Zip:" line 10 column 17.
    05 ask-zip entry-field line 10 column 22 using zip-data.
    
    05 label-sex label "Sex:" line 12 column 2.
    05 ask-sex entry-field line 12 column 10 using sex-data.
    
    05 label-cust label "Current Customer (Y/N): " line 14 column 2.
    05 ask-cust entry-field line 14 column 28 using cust-data.
    
    05 label-sport label "Sports" line 16 column 2.

* Alter the list-box so its size and position is fractional,
* and eliminate the numbers; they were useful to the program,
* but not the user, and so should be eliminated.  The program
* now checks the name and restores the number internally.

    05 list-sport list-box
        line 17.5 column 2 lines 3.5 size 20
        item-to-add = "Golf"
	item-to-add = "Bowling"
	item-to-add = "Hockey"
	using sport-item
	.

procedure division.
main-paragraph.

* Create an initial window by specifying it, rather than using default

    display standard window 
        title ="Gui Screen"
        size 60 lines 25
	foreground-color 0
	
    display main-screen
    
main-loop.    
    accept main-screen
    move sport-item(1:1) to sport-data

* Turn the name of the sport into the original number so
* the original program behavior is retained.

    evaluate sport-item(1:1)
        when "G" move 1 to sport-data
	when "B" move 2 to sport-data
	when "H" move 3 to sport-data
    end-evaluate	
    perform display-data
    go to main-loop
    .
display-data.
    display "title: " title-data upon sysout
    display "name: " name-data upon sysout
    display "addr: " addr-data upon sysout
    display "city: " city-data upon sysout
    display "state: " state-data upon sysout
    display "zip: " zip-data upon sysout
    display "sex: " sex-data upon sysout
    display "cust: " cust-data upon sysout
    display "sport: " sport-data upon sysout
    .
    
