      *
      * VSAMPLE
      *
      * Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
      *
      * This file and associated files are copyrighted information
      * of Heirloom Computing.  Permission is granted for usage in
      * conjunction with the Elastic COBOL product.
      *
       IDENTIFICATION DIVISION.
       PROGRAM-ID. VSAMPLE.
       ENVIRONMENT DIVISION.
       CONFIGURATION SECTION.
       SPECIAL-NAMES.
      
      * Enable graphical (GFX) or text (TEXT) mode for ViewJ programmatically.
      * This may also be passed as a parameter to the program to enable it.
      *            
      *    DYNAMIC CONFIGURATION "VIEWJ_MODE" IS "GFX".
      
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      
       01 VIEW-FORMFILE           PIC X(16) VALUE SPACES.
       01 VIEW-TERMNAME           PIC X(36) VALUE SPACES.
       
       01 COMAREA.
          05  CSTATUS             PIC S9(4) COMP VALUE 0.
          05  LANGUAGE            PIC S9(4) COMP VALUE 0.
          05  COMAREALEN          PIC S9(4) COMP VALUE 0.
          05  USERBUFLEN          PIC S9(4) COMP VALUE 0.
          05  CMODE               PIC S9(4) COMP VALUE 0.
          05  LASTKEY             PIC S9(4) COMP VALUE 0.
          05  NUMERRS             PIC S9(4) COMP VALUE 0.
          05  WINDOWENH           PIC S9(4) COMP VALUE 0.
          05  MULTIUSAGE          PIC S9(4) COMP VALUE 0.
          05  LABELOPTIONS        PIC S9(4) COMP VALUE 0.
          05  CFNAME              PIC X(16) VALUE SPACES.
          05  NFNAME              PIC X(16) VALUE SPACES.
          05  REPEATAPP           PIC S9(4) COMP VALUE 0.
          05  FREEZEAPP           PIC S9(4) COMP VALUE 0.
          05  CFNUMLINES          PIC S9(4) COMP VALUE 0.
          05  DBUFLEN             PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  LOOKAHEAD           PIC S9(4) COMP VALUE 0.
          05  DELETEFLAG          PIC S9(4) COMP VALUE 0.
          05  SHOWCONTROL         PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  PRINTFILENUM        PIC S9(4) COMP VALUE 0.
          05  FILERRNUM           PIC S9(4) COMP VALUE 0.
          05  ERRFILENUM          PIC S9(4) COMP VALUE 0.
          05  FORMSTORESIZE       PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  NUMRECS             PIC S9(8) COMP VALUE 0.
          05  RECNUM              PIC S9(8) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  TERMFILEN           PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  RETRIES             PIC S9(4) COMP VALUE 0.
          05  TERMOPTIONS         PIC S9(4) COMP VALUE 0.
          05  ENVIRON             PIC S9(4) COMP VALUE 0.
          05  USERTIME            PIC S9(4) COMP VALUE 0.
          05  IDENTIFIER          PIC S9(4) COMP VALUE 0.
          05  LABELINFO           PIC S9(4) COMP VALUE 0.
          05  BUFFERCONTROL       PIC S9(4) COMP VALUE 0.
          05  BUFFERSTATUS        PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC S9(4) COMP VALUE 0.
          05  FILLER              PIC X(30).             
      
       PROCEDURE DIVISION.
       MAIN-PARAGRAPH.
           MOVE "VSAMPLE" TO VIEW-FORMFILE
           MOVE 0 TO CSTATUS
       
           MOVE 0 TO CSTATUS         
           CALL "VOPENFORMF" USING COMAREA VIEW-FORMFILE
           IF CSTATUS NOT = 0
                DISPLAY "VOPENFORMF ERROR: CSTATUS IS " 
                   CSTATUS UPON SYSOUT
                STOP ALL RUN
           END-IF
      
           MOVE 0             TO CSTATUS
           MOVE 0             TO LANGUAGE, REPEATAPP
           MOVE 60            TO COMAREALEN
           MOVE "MAIN           " TO NFNAME
      
           CALL "VGETNEXTFORM" USING COMAREA
           IF CSTATUS NOT = 0
               DISPLAY "VGETNEXTFORM ERROR: CSTATUS IS " 
                  CSTATUS UPON SYSOUT
               GO TO SHUTDOWN 
           END-IF
           
           CALL "VINITFORM" USING COMAREA
           IF CSTATUS NOT = 0
               DISPLAY "VINITFORM ERROR: CSTATUS IS " 
                  CSTATUS UPON SYSOUT
               GO TO SHUTDOWN
           END-IF
      
           CALL "VPUTWINDOW" USING COMAREA "Status Message" 14
      	   IF CSTATUS NOT = 0
               DISPLAY "VPUTWINDOW ERROR: CSTATUS IS "
                  CSTATUS UPON SYSOUT
               GO TO SHUTDOWN
           END-IF
           
           CALL "VSHOWFORM" USING COMAREA
           IF CSTATUS NOT = 0
               DISPLAY "VSHOWFORM ERROR: CSTATUS IS " 
                  CSTATUS UPON SYSOUT
               GO TO SHUTDOWN
           END-IF
           
           CALL "VREADFIELDS" USING COMAREA 
           IF CSTATUS NOT = 0
               DISPLAY "VREADFIELDS ERROR: CSTATUS IS " 
                  CSTATUS UPON SYSOUT
               GO TO SHUTDOWN
           END-IF
          
           GO TO SHUTDOWN.
      
       SHUTDOWN.
           MOVE 0 TO CSTATUS.
           CALL "VCLOSEFORMF" USING COMAREA.
           MOVE 0 TO CSTATUS.
           CALL "VCLOSETERM"  USING COMAREA.       
           STOP ALL RUN.
