*
* XMLREAD
*
* Copyright (C) 2010-2023 Heirloom Computing Inc.  All Rights Reserved.
*
* This file and associated files are copyrighted information
* of Heirloom Computing.  Permission is granted for usage in 
* conjunction with the Elastic COBOL product.
*
id division.
program-id. xmlread.

environment division.
input-output section.
file-control.
    select xml-file assign to "xmldata.xml"
    organization is xml
    file status is file-status message-1 message-2
    .

data division.
file section.
fd xml-file.

01 x-customer-database-tag identified by "customer-database".
  05 x-customer-tag identified by "customer".
    10 x-exist attribute identified by "existing" pic x(4).
    
    10 x-name-tag identified by "name".
      15 x-first-tag identified by "first".
        20 x-nick attribute identified by "nickname" pic x.
        20 x-first-group content.
	  25 x-first-name content-name pic x(5).
	  25 x-first-offset content-offset pic 9(3).
	  25 x-first-length content-length pic 9(3).
	  25 x-first content-data pic x(10).
      15 x-last-tag identified by "last".
        20 x-last content pic x(20).
	20 x-origin-group attribute identified by "origin".
	  25 x-origin-name attribute-name pic x(10).
	  25 x-origin-uri attribute-uri pic x(10).
	  25 x-origin-local attribute-local pic x(10).
	  25 x-origin-qname attribute-qname pic x(10).
	  25 x-origin-type attribute-type pic x(10).
	  25 x-origin attribute-data pic x(20).
	  25 x-origin-length attribute-length pic 9(3).
	20 x-length attribute identified by "length" pic x(2).
	20 x-citynamed attribute identified by "citynamed" pic x(2).
	20 x-particle attribute identified by "particle" pic x(4).
	
    10 x-address-tag identified by "address".
      15 x-address content pic x(20).
      
    10 x-city-tag identified by "city".
      15 x-city content pic x(20).
      
    10 x-state-tag identified by "state".
      15 x-state content pic x(2).
      
    10 x-zip-tag identified by "zip".
      15 x-zip content pic x(5).

    10 locator-group locator.      
      15 loc-public locator-public pic x(20) value spaces.
      15 loc-system locator-system pic x(20) value spaces.
      15 loc-line   locator-line   pic x(5) value spaces.
      15 loc-col    locator-column pic x(5) value spaces.
      
working-storage section.

01 file-status pic xx value space.
01 message-1 pic x(20) value spaces.
01 message-2 pic x(20) value spaces.
01 another-item pic xx.

procedure division.
main-paragraph.

    display "open input" upon sysout
    
    initialize x-customer-database-tag
    
    open input xml-file
    
    display "opened." upon sysout
    
    perform read-it until file-status = 10 or 30
    
    display "close" upon sysout
    close xml-file
    
    display "done" upon sysout
    
    stop all run
    .
    
read-it.
    read xml-file
    
    if file-status < 20 then
    
        display "--" upon sysout
        display "first  =" x-first "(" x-nick ")" upon sysout
	display " exist =" x-exist upon sysout
	display "        name='" x-first-name "'" upon sysout
	display "        offset=" x-first-offset upon sysout
	display "        length=" x-first-length upon sysout
        display "last   =" x-last upon sysout
	display " origin=" x-origin upon sysout
	display "        origin-name='" x-origin-name "'" upon sysout
	display "        origin-uri='" x-origin-uri "'" upon sysout
	display "        origin-local='" x-origin-local "'" upon sysout
	display "        origin-qname='" x-origin-qname "'" upon sysout
	display "        origin-type='" x-origin-type "'" upon sysout
	display "        origin-length=" x-origin-length upon sysout
	display " length=" x-length upon sysout
	display " citynm=" x-citynamed upon sysout
	display " partcl=" x-particle upon sysout
        display "address=" x-address upon sysout
        display "city   =" x-city upon sysout
        display "state  =" x-state upon sysout
        display "zip    =" x-zip upon sysout
    else
    
        display "locator:" upon sysout
	display " public: " loc-public upon sysout
	display " system: " loc-system upon sysout
	display " line  : " loc-line upon sysout
	display " column: " loc-col upon sysout
	
    end-if
    
    display "file-status=" file-status ", " message-1 ", " message-2 upon sysout
    .
    

